/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import org.graylog.shaded.opensearch2.org.apache.lucene.util.LongHeap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NumericUtils;

public class NeighborQueue {
    private final LongHeap heap;
    private final Order order;
    private int visitedCount;
    private boolean incomplete;

    public NeighborQueue(int initialSize, boolean reversed) {
        this.heap = new LongHeap(initialSize);
        this.order = reversed ? Order.REVERSED : Order.NATURAL;
    }

    public int size() {
        return this.heap.size();
    }

    public void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public boolean insertWithOverflow(int newNode, float newScore) {
        return this.heap.insertWithOverflow(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return this.order.apply((long)NumericUtils.floatToSortableInt(score) << 32 | (long)node);
    }

    public int pop() {
        return (int)this.order.apply(this.heap.pop());
    }

    int[] nodes() {
        int size = this.size();
        int[] nodes = new int[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = (int)this.order.apply(this.heap.get(i + 1));
        }
        return nodes;
    }

    public int topNode() {
        return (int)this.order.apply(this.heap.top());
    }

    public float topScore() {
        return NumericUtils.sortableIntToFloat((int)(this.order.apply(this.heap.top()) >> 32));
    }

    public void clear() {
        this.heap.clear();
        this.visitedCount = 0;
    }

    public int visitedCount() {
        return this.visitedCount;
    }

    public void setVisitedCount(int visitedCount) {
        this.visitedCount = visitedCount;
    }

    public boolean incomplete() {
        return this.incomplete;
    }

    public void markIncomplete() {
        this.incomplete = true;
    }

    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }

    private static enum Order {
        NATURAL{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        REVERSED{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }
}

