/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.HnswGraph;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw.NeighborArray;

public final class OnHeapHnswGraph
extends HnswGraph {
    private final int maxConn;
    private int numLevels;
    private int entryNode;
    private final List<int[]> nodesByLevel;
    private final List<List<NeighborArray>> graph;
    private int upto;
    private NeighborArray cur;

    OnHeapHnswGraph(int maxConn, int levelOfFirstNode) {
        this.maxConn = maxConn;
        this.numLevels = levelOfFirstNode + 1;
        this.graph = new ArrayList<List<NeighborArray>>(this.numLevels);
        this.entryNode = 0;
        for (int i = 0; i < this.numLevels; ++i) {
            this.graph.add(new ArrayList());
            this.graph.get(i).add(new NeighborArray(Math.max(32, maxConn / 4)));
        }
        this.nodesByLevel = new ArrayList<int[]>(this.numLevels);
        this.nodesByLevel.add(null);
        for (int l = 1; l < this.numLevels; ++l) {
            this.nodesByLevel.add(new int[]{0});
        }
    }

    public NeighborArray getNeighbors(int level, int node) {
        if (level == 0) {
            return this.graph.get(level).get(node);
        }
        int nodeIndex = Arrays.binarySearch(this.nodesByLevel.get(level), 0, this.graph.get(level).size(), node);
        assert (nodeIndex >= 0);
        return this.graph.get(level).get(nodeIndex);
    }

    @Override
    public int size() {
        return this.graph.get(0).size();
    }

    public void addNode(int level, int node) {
        if (level > 0) {
            if (level >= this.numLevels) {
                for (int i = this.numLevels; i <= level; ++i) {
                    this.graph.add(new ArrayList());
                    this.nodesByLevel.add(new int[]{node});
                }
                this.numLevels = level + 1;
                this.entryNode = node;
            } else {
                int[] nodes = this.nodesByLevel.get(level);
                int idx = this.graph.get(level).size();
                if (idx < nodes.length) {
                    nodes[idx] = node;
                } else {
                    nodes = ArrayUtil.grow(nodes);
                    nodes[idx] = node;
                    this.nodesByLevel.set(level, nodes);
                }
            }
        }
        this.graph.get(level).add(new NeighborArray(this.maxConn + 1));
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return this.numLevels;
    }

    @Override
    public int entryNode() {
        return this.entryNode;
    }

    @Override
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (level == 0) {
            return new HnswGraph.NodesIterator(this.size());
        }
        return new HnswGraph.NodesIterator(this.nodesByLevel.get(level), this.graph.get(level).size());
    }
}

