/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.packed.PackedInts;

public final class DirectWriter {
    final int bitsPerValue;
    final long numValues;
    final DataOutput output;
    long count;
    boolean finished;
    int off;
    final byte[] nextBlocks;
    final long[] nextValues;
    static final int[] SUPPORTED_BITS_PER_VALUE = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64};

    DirectWriter(DataOutput output, long numValues, int bitsPerValue) {
        this.output = output;
        this.numValues = numValues;
        this.bitsPerValue = bitsPerValue;
        int memoryBudgetInBits = Math.multiplyExact(8, 1024);
        int bufferSize = memoryBudgetInBits / (64 + bitsPerValue);
        assert (bufferSize > 0);
        bufferSize = Math.toIntExact(bufferSize + 63) & 0xFFFFFFC0;
        this.nextValues = new long[bufferSize];
        this.nextBlocks = new byte[bufferSize * bitsPerValue / 8 + 8 - 1];
    }

    public void add(long l) throws IOException {
        assert (this.bitsPerValue == 64 || l >= 0L && l <= PackedInts.maxValue(this.bitsPerValue)) : this.bitsPerValue;
        assert (!this.finished);
        if (this.count >= this.numValues) {
            throw new EOFException("Writing past end of stream");
        }
        this.nextValues[this.off++] = l;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        ++this.count;
    }

    private void flush() throws IOException {
        if (this.off == 0) {
            return;
        }
        Arrays.fill(this.nextValues, this.off, this.nextValues.length, 0L);
        DirectWriter.encode(this.nextValues, this.off, this.nextBlocks, this.bitsPerValue);
        int blockCount = (int)PackedInts.Format.PACKED.byteCount(2, this.off, this.bitsPerValue);
        this.output.writeBytes(this.nextBlocks, blockCount);
        this.off = 0;
    }

    private static void encode(long[] nextValues, int upTo, byte[] nextBlocks, int bitsPerValue) {
        if ((bitsPerValue & 7) == 0) {
            int bytesPerValue = bitsPerValue / 8;
            int i = 0;
            int o = 0;
            while (i < upTo) {
                long l = nextValues[i];
                if (bitsPerValue > 32) {
                    BitUtil.VH_LE_LONG.set(nextBlocks, o, l);
                } else if (bitsPerValue > 16) {
                    BitUtil.VH_LE_INT.set(nextBlocks, o, (int)l);
                } else if (bitsPerValue > 8) {
                    BitUtil.VH_LE_SHORT.set(nextBlocks, o, (short)l);
                } else {
                    nextBlocks[o] = (byte)l;
                }
                ++i;
                o += bytesPerValue;
            }
        } else if (bitsPerValue < 8) {
            int valuesPerLong = 64 / bitsPerValue;
            int i = 0;
            int o = 0;
            while (i < upTo) {
                long v = 0L;
                for (int j = 0; j < valuesPerLong; ++j) {
                    v |= nextValues[i + j] << bitsPerValue * j;
                }
                BitUtil.VH_LE_LONG.set(nextBlocks, o, v);
                i += valuesPerLong;
                o += 8;
            }
        } else {
            int numBytesFor2Values = bitsPerValue * 2 / 8;
            int i = 0;
            int o = 0;
            while (i < upTo) {
                long l1 = nextValues[i];
                long l2 = nextValues[i + 1];
                long merged = l1 | l2 << bitsPerValue;
                if (bitsPerValue <= 16) {
                    BitUtil.VH_LE_INT.set(nextBlocks, o, (int)merged);
                } else {
                    BitUtil.VH_LE_LONG.set(nextBlocks, o, merged);
                }
                i += 2;
                o += numBytesFor2Values;
            }
        }
    }

    public void finish() throws IOException {
        if (this.count != this.numValues) {
            throw new IllegalStateException("Wrong number of values added, expected: " + this.numValues + ", got: " + this.count);
        }
        assert (!this.finished);
        this.flush();
        int paddingBitsNeeded = this.bitsPerValue > 32 ? 64 - this.bitsPerValue : (this.bitsPerValue > 16 ? 32 - this.bitsPerValue : (this.bitsPerValue > 8 ? 16 - this.bitsPerValue : 0));
        assert (paddingBitsNeeded >= 0);
        int paddingBytesNeeded = (paddingBitsNeeded + 8 - 1) / 8;
        assert (paddingBytesNeeded <= 3);
        for (int i = 0; i < paddingBytesNeeded; ++i) {
            this.output.writeByte((byte)0);
        }
        this.finished = true;
    }

    public static DirectWriter getInstance(DataOutput output, long numValues, int bitsPerValue) {
        if (Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsPerValue) < 0) {
            throw new IllegalArgumentException("Unsupported bitsPerValue " + bitsPerValue + ". Did you use bitsRequired?");
        }
        return new DirectWriter(output, numValues, bitsPerValue);
    }

    private static int roundBits(int bitsRequired) {
        int index = Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsRequired);
        if (index < 0) {
            return SUPPORTED_BITS_PER_VALUE[-index - 1];
        }
        return bitsRequired;
    }

    public static int bitsRequired(long maxValue) {
        return DirectWriter.roundBits(PackedInts.bitsRequired(maxValue));
    }

    public static int unsignedBitsRequired(long maxValue) {
        return DirectWriter.roundBits(PackedInts.unsignedBitsRequired(maxValue));
    }
}

