/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardsObserver;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.AckedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public final class AutoCreateAction
extends ActionType<CreateIndexResponse> {
    public static final AutoCreateAction INSTANCE = new AutoCreateAction();
    public static final String NAME = "indices:admin/auto_create";

    private AutoCreateAction() {
        super(NAME, CreateIndexResponse::new);
    }

    static ComposableIndexTemplate.DataStreamTemplate resolveAutoCreateDataStream(CreateIndexRequest request, Metadata metadata) {
        ComposableIndexTemplate composableIndexTemplate;
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, request.index(), false);
        if (v2Template != null && (composableIndexTemplate = metadata.templatesV2().get(v2Template)).getDataStreamTemplate() != null) {
            return composableIndexTemplate.getDataStreamTemplate();
        }
        return null;
    }

    public static final class TransportAction
    extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
        private final ActiveShardsObserver activeShardsObserver;
        private final MetadataCreateIndexService createIndexService;
        private final MetadataCreateDataStreamService metadataCreateDataStreamService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService, MetadataCreateDataStreamService metadataCreateDataStreamService) {
            super(AutoCreateAction.NAME, transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver);
            this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
            this.createIndexService = createIndexService;
            this.metadataCreateDataStreamService = metadataCreateDataStreamService;
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected CreateIndexResponse read(StreamInput in) throws IOException {
            return new CreateIndexResponse(in);
        }

        @Override
        protected void masterOperation(final CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> finalListener) {
            final AtomicReference indexNameRef = new AtomicReference();
            ActionListener<ClusterStateUpdateResponse> listener = ActionListener.wrap(response -> {
                String indexName = (String)indexNameRef.get();
                assert (indexName != null);
                if (response.isAcknowledged()) {
                    this.activeShardsObserver.waitForActiveShards(new String[]{indexName}, ActiveShardCount.DEFAULT, request.timeout(), shardsAcked -> finalListener.onResponse(new CreateIndexResponse(true, (boolean)shardsAcked, indexName)), finalListener::onFailure);
                } else {
                    finalListener.onResponse(new CreateIndexResponse(false, false, indexName));
                }
            }, finalListener::onFailure);
            this.clusterService.submitStateUpdateTask("auto create [" + request.index() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

                @Override
                protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                    return new ClusterStateUpdateResponse(acknowledged);
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    ComposableIndexTemplate.DataStreamTemplate dataStreamTemplate = AutoCreateAction.resolveAutoCreateDataStream(request, currentState.metadata());
                    if (dataStreamTemplate != null) {
                        MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest createRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(request.index(), request.masterNodeTimeout(), request.timeout());
                        ClusterState clusterState = metadataCreateDataStreamService.createDataStream(createRequest, currentState);
                        indexNameRef.set(clusterState.metadata().dataStreams().get(request.index()).getIndices().get(0).getName());
                        return clusterState;
                    }
                    String indexName = indexNameExpressionResolver.resolveDateMathExpression(request.index());
                    indexNameRef.set(indexName);
                    CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request.cause(), indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
                    return createIndexService.applyCreateIndexRequest(currentState, updateRequest, false);
                }
            });
        }

        @Override
        protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
            return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
        }
    }
}

