/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchGenerationException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.Alias;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActiveShardCount;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends AcknowledgedRequest<CreateIndexRequest>
implements IndicesRequest {
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private String cause = "";
    private String index;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private String mappings = "{}";
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;

    public CreateIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getVersion().before(Version.V_2_0_0)) {
            int size = in.readVInt();
            if (size == 1) {
                String type = in.readString();
                if (!"_doc".equals(type)) {
                    throw new IllegalArgumentException("Expected to receive mapping type of [_doc] but got [" + type + "]");
                }
                this.mappings = in.readString();
            } else if (size != 0) {
                throw new IllegalStateException("Expected to read 0 or 1 mappings, but received " + size);
            }
        } else {
            this.mappings = in.readString();
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
            in.readBoolean();
        }
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
    }

    public CreateIndexRequest() {
    }

    public CreateIndexRequest(String index) {
        this(index, Settings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index, Settings settings) {
        this.index = index;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index) {
        this.index = index;
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        this.settings(Strings.toString(builder), builder.contentType());
        return this;
    }

    public CreateIndexRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public CreateIndexRequest mapping(String mapping) {
        this.mappings = mapping;
        return this;
    }

    public CreateIndexRequest mapping(String source, XContentType xContentType) {
        return this.mapping(new BytesArray(source), xContentType);
    }

    private CreateIndexRequest mapping(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        Map<String, Object> mappingAsMap = XContentHelper.convertToMap(source, false, xContentType).v2();
        return this.mapping("_doc", mappingAsMap);
    }

    public CreateIndexRequest mapping(XContentBuilder source) {
        return this.mapping(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest mapping(Map<String, ?> source) {
        return this.mapping("_doc", source);
    }

    @Deprecated
    private CreateIndexRequest mapping(String type, Map<String, ?> source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = Collections.singletonMap("_doc", source);
        } else if (!"_doc".equals(type)) {
            source = Collections.singletonMap("_doc", source.get(type));
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.mapping(Strings.toString(builder));
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest simpleMapping(String ... source) {
        this.mapping(PutMappingRequest.simpleMapping(source));
        return this;
    }

    public CreateIndexRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public CreateIndexRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public CreateIndexRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public CreateIndexRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public CreateIndexRequest aliases(BytesReference source) {
        CreateIndexRequest createIndexRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                createIndexRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return createIndexRequest;
    }

    public CreateIndexRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    public CreateIndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public CreateIndexRequest source(XContentBuilder source) {
        return this.source(BytesReference.bytes(source), source.contentType());
    }

    public CreateIndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public CreateIndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public CreateIndexRequest source(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        this.source(XContentHelper.convertToMap(source, false, xContentType).v2(), LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public CreateIndexRequest source(Map<String, ?> source, DeprecationHandler deprecationHandler) {
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String name = entry.getKey();
            if (SETTINGS.match(name, deprecationHandler)) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new OpenSearchParseException("key [settings] must be an object", new Object[0]);
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (MAPPINGS.match(name, deprecationHandler)) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            if (ALIASES.match(name, deprecationHandler)) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new OpenSearchParseException("unknown key [{}] for create index", name);
        }
        return this;
    }

    public String mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public CreateIndexRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        Settings.writeSettingsToStream(this.settings, out);
        if (out.getVersion().before(Version.V_2_0_0)) {
            if ("{}".equals(this.mappings)) {
                out.writeVInt(0);
            } else {
                out.writeVInt(1);
                out.writeString("_doc");
                out.writeString(this.mappings);
            }
        } else {
            out.writeString(this.mappings);
        }
        out.writeVInt(this.aliases.size());
        for (Alias alias : this.aliases) {
            alias.writeTo(out);
        }
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            out.writeBoolean(true);
        }
        this.waitForActiveShards.writeTo(out);
    }
}

