/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.get;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.info.TransportClusterInfoAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexAbstraction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.IndexScopedSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.SettingsFilter;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/get", transportService, clusterService, threadPool, actionFilters, GetIndexRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected GetIndexResponse read(StreamInput in) throws IOException {
        return new GetIndexResponse(in);
    }

    @Override
    protected void doMasterOperation(GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        ImmutableOpenMap<String, MappingMetadata> mappingsResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, List<AliasMetadata>> aliasesResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> defaultSettings = ImmutableOpenMap.of();
        ImmutableOpenMap<String, String> dataStreams = ImmutableOpenMap.builder().putAll(StreamSupport.stream(state.metadata().findDataStreams(concreteIndices).spliterator(), false).collect(Collectors.toMap(k -> (String)k.key, v -> ((IndexAbstraction.DataStream)v.value).getName()))).build();
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        block7: for (GetIndexRequest.Feature feature : features) {
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block7;
                    try {
                        mappingsResult = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter());
                        doneMappings = true;
                        continue block7;
                    }
                    catch (IOException e) {
                        listener.onFailure(e);
                        return;
                    }
                }
                case ALIASES: {
                    if (doneAliases) continue block7;
                    aliasesResult = state.metadata().findAllAliases(concreteIndices);
                    doneAliases = true;
                    continue block7;
                }
                case SETTINGS: {
                    if (doneSettings) continue block7;
                    ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
                    ImmutableOpenMap.Builder<String, Settings> defaultSettingsMapBuilder = ImmutableOpenMap.builder();
                    for (String index : concreteIndices) {
                        Settings indexSettings = state.metadata().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                        if (!request.includeDefaults()) continue;
                        Settings defaultIndexSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
                        defaultSettingsMapBuilder.put(index, defaultIndexSettings);
                    }
                    settings = settingsMapBuilder.build();
                    defaultSettings = defaultSettingsMapBuilder.build();
                    doneSettings = true;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("feature [" + feature + "] is not valid");
                }
            }
        }
        listener.onResponse(new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings, defaultSettings, dataStreams));
    }
}

