/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.post.SimulateIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.TransportMasterNodeReadAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasValidator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Template;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.CompressedXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.DocumentMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportSimulateIndexTemplateAction
extends TransportMasterNodeReadAction<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate_index", transportService, clusterService, threadPool, actionFilters, SimulateIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    @Override
    protected void masterOperation(SimulateIndexTemplateRequest request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        if (request.getIndexTemplateRequest() != null) {
            String simulateTemplateToAdd = "simulate_index_template_" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            stateWithTemplate = state;
        }
        String matchingTemplate = MetadataIndexTemplateService.findV2Template(stateWithTemplate.metadata(), request.getIndexName(), false);
        if (matchingTemplate == null) {
            listener.onResponse(new SimulateIndexTemplateResponse(null, null));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState(matchingTemplate, request.getIndexName(), stateWithTemplate);
        ComposableIndexTemplate templateV2 = tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.getIndexName(), stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static ClusterState resolveTemporaryState(String matchingTemplate, String indexName, ClusterState simulatedState) {
        Settings settings = MetadataIndexTemplateService.resolveSettings(simulatedState.metadata(), matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(dummySettings).build();
        return ClusterState.builder(simulatedState).metadata(Metadata.builder(simulatedState.metadata()).put(indexMetadata, true).build()).build();
    }

    public static Template resolveTemplate(String matchingTemplate, String indexName, ClusterState simulatedState, NamedXContentRegistry xContentRegistry, IndicesService indicesService, AliasValidator aliasValidator) throws Exception {
        Settings settings = MetadataIndexTemplateService.resolveSettings(simulatedState.metadata(), matchingTemplate);
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(simulatedState.metadata(), matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder(indexName).settings(dummySettings).build();
        ClusterState tempClusterState = ClusterState.builder(simulatedState).metadata(Metadata.builder(simulatedState.metadata()).put(indexMetadata, true).build()).build();
        List aliases = indicesService.withTempIndexService(indexMetadata, tempIndexService -> MetadataCreateIndexService.resolveAndValidateAliases(indexName, Collections.emptySet(), resolvedAliases, tempClusterState.metadata(), aliasValidator, xContentRegistry, tempIndexService.newQueryShardContext(0, null, () -> 0L, null)));
        Map<String, AliasMetadata> aliasesByName = aliases.stream().collect(Collectors.toMap(AliasMetadata::getAlias, Function.identity()));
        List<Map<String, Object>> mappings = MetadataCreateIndexService.collectV2Mappings("{}", simulatedState, matchingTemplate, xContentRegistry, indexName);
        CompressedXContent mergedMapping = indicesService.withTempIndexService(indexMetadata, tempIndexService -> {
            MapperService mapperService = tempIndexService.mapperService();
            for (Map mapping : mappings) {
                if (mapping.isEmpty()) continue;
                mapperService.merge("_doc", mapping, MapperService.MergeReason.INDEX_TEMPLATE);
            }
            DocumentMapper documentMapper = mapperService.documentMapper();
            return documentMapper != null ? documentMapper.mappingSource() : null;
        });
        return new Template(settings, mergedMapping, aliasesByName);
    }
}

