/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchPhaseResults;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AtomicArray;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;

class ArraySearchPhaseResults<Result extends SearchPhaseResult>
extends SearchPhaseResults<Result> {
    final AtomicArray<Result> results;

    ArraySearchPhaseResults(int size) {
        super(size);
        this.results = new AtomicArray(size);
    }

    @Override
    Stream<Result> getSuccessfulResults() {
        return this.results.asList().stream();
    }

    @Override
    void consumeResult(Result result, Runnable next) {
        assert (this.results.get(((SearchPhaseResult)result).getShardIndex()) == null) : "shardIndex: " + ((SearchPhaseResult)result).getShardIndex() + " is already set";
        this.results.set(((SearchPhaseResult)result).getShardIndex(), result);
        next.run();
    }

    @Override
    boolean hasResult(int shardIndex) {
        return this.results.get(shardIndex) != null;
    }

    @Override
    AtomicArray<Result> getAtomicArray() {
        return this.results;
    }
}

