/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchContextIdForNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.ByteBufferStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchShardTarget;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.AliasFilter;

public class SearchContextId {
    private final Map<ShardId, SearchContextIdForNode> shards;
    private final Map<String, AliasFilter> aliasFilter;

    private SearchContextId(Map<ShardId, SearchContextIdForNode> shards, Map<String, AliasFilter> aliasFilter) {
        this.shards = shards;
        this.aliasFilter = aliasFilter;
    }

    public Map<ShardId, SearchContextIdForNode> shards() {
        return this.shards;
    }

    public Map<String, AliasFilter> aliasFilter() {
        return this.aliasFilter;
    }

    public static String encode(List<SearchPhaseResult> searchPhaseResults, Map<String, AliasFilter> aliasFilter, Version version) {
        HashMap<ShardId, SearchContextIdForNode> shards = new HashMap<ShardId, SearchContextIdForNode>();
        for (SearchPhaseResult searchPhaseResult : searchPhaseResults) {
            SearchShardTarget target = searchPhaseResult.getSearchShardTarget();
            shards.put(target.getShardId(), new SearchContextIdForNode(target.getClusterAlias(), target.getNodeId(), searchPhaseResult.getContextId()));
        }
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.setVersion(version);
            Version.writeVersion(version, out);
            out.writeMap(shards, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
            out.writeMap(aliasFilter, StreamOutput::writeString, (o, v) -> v.writeTo(o));
            String string = Base64.getUrlEncoder().encodeToString(BytesReference.toBytes(out.bytes()));
            out.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static SearchContextId decode(NamedWriteableRegistry namedWriteableRegistry, String id) {
        SearchContextId searchContextId;
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ByteBuffer.wrap(Base64.getUrlDecoder().decode(id));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid id: [" + id + "]", e);
        }
        NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(new ByteBufferStreamInput(byteBuffer), namedWriteableRegistry);
        try {
            Version version = Version.readVersion(in);
            ((StreamInput)in).setVersion(version);
            Map<ShardId, SearchContextIdForNode> shards = in.readMap(ShardId::new, SearchContextIdForNode::new);
            Map<String, AliasFilter> aliasFilters = in.readMap(StreamInput::readString, AliasFilter::new);
            if (((StreamInput)in).available() > 0) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            searchContextId = new SearchContextId(Collections.unmodifiableMap(shards), Collections.unmodifiableMap(aliasFilters));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((StreamInput)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ((StreamInput)in).close();
        return searchContextId;
    }

    public String[] getActualIndices() {
        HashSet<Object> indices = new HashSet<Object>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : this.shards().entrySet()) {
            String indexName = entry.getKey().getIndexName();
            String clusterAlias = entry.getValue().getClusterAlias();
            if (Strings.isEmpty(clusterAlias)) {
                indices.add(indexName);
                continue;
            }
            indices.add(clusterAlias + ":" + indexName);
        }
        return indices.toArray(new String[0]);
    }
}

