/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.search;

import java.util.Objects;
import java.util.function.BiFunction;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.node.ResponseCollectorService;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchPhaseResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.QueryFetchSearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;

public final class SearchExecutionStatsCollector
implements ActionListener<SearchPhaseResult> {
    private final ActionListener<SearchPhaseResult> listener;
    private final String nodeId;
    private final ResponseCollectorService collector;
    private final long startNanos;

    SearchExecutionStatsCollector(ActionListener<SearchPhaseResult> listener, ResponseCollectorService collector, String nodeId) {
        this.listener = Objects.requireNonNull(listener, "listener cannot be null");
        this.collector = Objects.requireNonNull(collector, "response collector cannot be null");
        this.startNanos = System.nanoTime();
        this.nodeId = nodeId;
    }

    public static BiFunction<Transport.Connection, SearchActionListener, ActionListener> makeWrapper(ResponseCollectorService service) {
        return (connection, originalListener) -> new SearchExecutionStatsCollector((ActionListener<SearchPhaseResult>)originalListener, service, connection.getNode().getId());
    }

    @Override
    public void onResponse(SearchPhaseResult response) {
        if (response instanceof QueryFetchSearchResult) {
            response.queryResult().getShardSearchRequest().setOutboundNetworkTime(0L);
            response.queryResult().getShardSearchRequest().setInboundNetworkTime(0L);
        }
        QuerySearchResult queryResult = response.queryResult();
        if (response.getShardSearchRequest() != null) {
            if (response.remoteAddress() != null) {
                response.getShardSearchRequest().setOutboundNetworkTime(Math.max(0L, System.currentTimeMillis() - response.getShardSearchRequest().getOutboundNetworkTime()));
            } else {
                response.getShardSearchRequest().setOutboundNetworkTime(0L);
                response.getShardSearchRequest().setInboundNetworkTime(0L);
            }
        }
        if (this.nodeId != null && queryResult != null) {
            long serviceTimeEWMA = queryResult.serviceTimeEWMA();
            int queueSize = queryResult.nodeQueueSize();
            long responseDuration = System.nanoTime() - this.startNanos;
            if (serviceTimeEWMA > 0L && queueSize >= 0) {
                this.collector.addNodeStatistics(this.nodeId, queueSize, responseDuration, serviceTimeEWMA);
            }
        }
        this.listener.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }
}

