/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.single.instance;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.UnavailableShardsException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.HandledTransportAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.single.instance.InstanceShardOperationRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateObserver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public abstract class TransportInstanceSingleOperationAction<Request extends InstanceShardOperationRequest<Request>, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    final String shardActionName;

    protected TransportInstanceSingleOperationAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request) {
        super(actionName, transportService, actionFilters, request);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.shardActionName = actionName + "[s]";
        transportService.registerRequestHandler(this.shardActionName, "same", request, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, request, listener).start();
    }

    protected abstract String executor(ShardId var1);

    protected abstract void shardOperation(Request var1, ActionListener<Response> var2);

    protected abstract Response newResponse(StreamInput var1) throws IOException;

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, Request request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ((InstanceShardOperationRequest)request).concreteIndex());
    }

    protected abstract void resolveRequest(ClusterState var1, Request var2);

    protected boolean retryOnFailure(Exception e) {
        return false;
    }

    protected TransportRequestOptions transportOptions() {
        return TransportRequestOptions.EMPTY;
    }

    protected abstract ShardIterator shards(ClusterState var1, Request var2);

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel, Task task) throws Exception {
            TransportInstanceSingleOperationAction.this.threadPool.executor(TransportInstanceSingleOperationAction.this.executor(((InstanceShardOperationRequest)request).shardId)).execute(new AbstractRunnable((InstanceShardOperationRequest)request){
                final /* synthetic */ InstanceShardOperationRequest val$request;
                {
                    this.val$request = instanceShardOperationRequest;
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        TransportInstanceSingleOperationAction.this.logger.warn("failed to send response for " + TransportInstanceSingleOperationAction.this.shardActionName, (Throwable)inner);
                    }
                }

                @Override
                protected void doRun() {
                    TransportInstanceSingleOperationAction.this.shardOperation(this.val$request, ActionListener.wrap(channel::sendResponse, this::onFailure));
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final Request request;
        private volatile ClusterStateObserver observer;
        private ShardIterator shardIt;
        final /* synthetic */ TransportInstanceSingleOperationAction this$0;

        AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
        }

        public void start() {
            ClusterState state = this.this$0.clusterService.state();
            this.observer = new ClusterStateObserver(state, this.this$0.clusterService, ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.logger, this.this$0.threadPool.getThreadContext());
            this.doStart(state);
        }

        protected void doStart(ClusterState clusterState) {
            try {
                ClusterBlockException blockException = this.this$0.checkGlobalBlock(clusterState);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                try {
                    ((InstanceShardOperationRequest)this.request).concreteIndex(this.this$0.indexNameExpressionResolver.concreteWriteIndex(clusterState, (IndicesRequest)this.request).getName());
                }
                catch (IndexNotFoundException e) {
                    if (!this.request.includeDataStreams() && e.getMetadataKeys().contains("opensearch.excluded_ds")) {
                        throw new IllegalArgumentException("only write ops with an op_type of create are allowed in data streams");
                    }
                    throw e;
                }
                this.this$0.resolveRequest(clusterState, this.request);
                blockException = this.this$0.checkRequestBlock(clusterState, this.request);
                if (blockException != null) {
                    if (blockException.retryable()) {
                        this.retry(blockException);
                        return;
                    }
                    throw blockException;
                }
                this.shardIt = this.this$0.shards(clusterState, this.request);
            }
            catch (Exception e) {
                this.listener.onFailure(e);
                return;
            }
            if (this.shardIt.size() == 0) {
                this.retry(null);
                return;
            }
            assert (this.shardIt.size() == 1);
            ShardRouting shard = this.shardIt.nextOrNull();
            assert (shard != null);
            if (!shard.active()) {
                this.retry(null);
                return;
            }
            ((InstanceShardOperationRequest)this.request).shardId = this.shardIt.shardId();
            DiscoveryNode node = clusterState.nodes().get(shard.currentNodeId());
            this.this$0.transportService.sendRequest(node, this.this$0.shardActionName, (TransportRequest)this.request, this.this$0.transportOptions(), new TransportResponseHandler<Response>(){

                @Override
                public Response read(StreamInput in) throws IOException {
                    return AsyncSingleAction.this.this$0.newResponse(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(Response response) {
                    AsyncSingleAction.this.listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    Throwable cause = exp.unwrapCause();
                    if (cause instanceof ConnectTransportException || cause instanceof NodeClosedException || AsyncSingleAction.this.this$0.retryOnFailure(exp)) {
                        AsyncSingleAction.this.retry((Exception)cause);
                    } else {
                        AsyncSingleAction.this.listener.onFailure(exp);
                    }
                }
            });
        }

        void retry(@Nullable Exception failure) {
            if (this.observer.isTimedOut()) {
                Exception listenFailure = failure;
                if (listenFailure == null) {
                    listenFailure = this.shardIt == null ? new UnavailableShardsException(((InstanceShardOperationRequest)this.request).concreteIndex(), -1, "Timeout waiting for [{}], request: {}", ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName) : new UnavailableShardsException(this.shardIt.shardId(), "[{}] shardIt, [{}] active : Timeout waiting for [{}], request: {}", this.shardIt.size(), this.shardIt.sizeActive(), ((InstanceShardOperationRequest)this.request).timeout(), this.this$0.actionName);
                }
                this.listener.onFailure(listenFailure);
                return;
            }
            this.observer.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    AsyncSingleAction.this.doStart(state);
                }

                @Override
                public void onClusterServiceClose() {
                    AsyncSingleAction.this.listener.onFailure(new NodeClosedException(AsyncSingleAction.this.this$0.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    AsyncSingleAction.this.doStart(AsyncSingleAction.this.observer.setAndGetObservedState());
                }
            }, ((InstanceShardOperationRequest)this.request).timeout());
        }
    }
}

