/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.TaskOperationFailure;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskId;

public class BaseTasksResponse
extends ActionResponse {
    protected static final String TASK_FAILURES = "task_failures";
    protected static final String NODE_FAILURES = "node_failures";
    private List<TaskOperationFailure> taskFailures;
    private List<OpenSearchException> nodeFailures;

    public BaseTasksResponse(List<TaskOperationFailure> taskFailures, List<? extends OpenSearchException> nodeFailures) {
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskOperationFailure>(taskFailures));
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<OpenSearchException>(nodeFailures));
    }

    public BaseTasksResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ArrayList<TaskOperationFailure> taskFailures = new ArrayList<TaskOperationFailure>(size);
        for (int i = 0; i < size; ++i) {
            taskFailures.add(new TaskOperationFailure(in));
        }
        size = in.readVInt();
        this.taskFailures = Collections.unmodifiableList(taskFailures);
        ArrayList<FailedNodeException> nodeFailures = new ArrayList<FailedNodeException>(size);
        for (int i = 0; i < size; ++i) {
            nodeFailures.add(new FailedNodeException(in));
        }
        this.nodeFailures = Collections.unmodifiableList(nodeFailures);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.taskFailures.size());
        for (TaskOperationFailure taskOperationFailure : this.taskFailures) {
            taskOperationFailure.writeTo(out);
        }
        out.writeVInt(this.nodeFailures.size());
        for (OpenSearchException openSearchException : this.nodeFailures) {
            openSearchException.writeTo(out);
        }
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public List<OpenSearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public void rethrowFailures(String operationName) {
        ExceptionsHelper.rethrowAndSuppress(Stream.concat(this.getNodeFailures().stream(), this.getTaskFailures().stream().map(f -> new OpenSearchException("{} of [{}] failed", (Throwable)f.getCause(), operationName, new TaskId(f.getNodeId(), f.getTaskId())))).collect(Collectors.toList()));
    }

    protected void toXContentCommon(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.getTaskFailures() != null && this.getTaskFailures().size() > 0) {
            builder.startArray(TASK_FAILURES);
            for (TaskOperationFailure taskOperationFailure : this.getTaskFailures()) {
                builder.startObject();
                builder.value((Object)taskOperationFailure);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.getNodeFailures() != null && this.getNodeFailures().size() > 0) {
            builder.startArray(NODE_FAILURES);
            for (OpenSearchException openSearchException : this.getNodeFailures()) {
                builder.startObject();
                openSearchException.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTasksResponse response = (BaseTasksResponse)o;
        return this.taskFailures.equals(response.taskFailures) && this.nodeFailures.equals(response.nodeFailures);
    }

    public int hashCode() {
        return Objects.hash(this.taskFailures, this.nodeFailures);
    }
}

