/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.Coordinator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.DiscoveryModule;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.SettingsBasedSeedHostsProvider;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class ClusterBootstrapService {
    public static final Setting<List<String>> INITIAL_MASTER_NODES_SETTING = Setting.listSetting("cluster.initial_master_nodes", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<List<String>> INITIAL_CLUSTER_MANAGER_NODES_SETTING = Setting.listSetting("cluster.initial_cluster_manager_nodes", INITIAL_MASTER_NODES_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<TimeValue> UNCONFIGURED_BOOTSTRAP_TIMEOUT_SETTING = Setting.timeSetting("discovery.unconfigured_bootstrap_timeout", TimeValue.timeValueSeconds(3L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    static final String BOOTSTRAP_PLACEHOLDER_PREFIX = "{bootstrap-placeholder}-";
    private static final Logger logger = LogManager.getLogger(ClusterBootstrapService.class);
    private final Set<String> bootstrapRequirements;
    @Nullable
    private final TimeValue unconfiguredBootstrapTimeout;
    private final TransportService transportService;
    private final Supplier<Iterable<DiscoveryNode>> discoveredNodesSupplier;
    private final BooleanSupplier isBootstrappedSupplier;
    private final Consumer<CoordinationMetadata.VotingConfiguration> votingConfigurationConsumer;
    private final AtomicBoolean bootstrappingPermitted = new AtomicBoolean(true);

    public ClusterBootstrapService(Settings settings, TransportService transportService, Supplier<Iterable<DiscoveryNode>> discoveredNodesSupplier, BooleanSupplier isBootstrappedSupplier, Consumer<CoordinationMetadata.VotingConfiguration> votingConfigurationConsumer) {
        String initialClusterManagerSettingName;
        String string = initialClusterManagerSettingName = INITIAL_CLUSTER_MANAGER_NODES_SETTING.exists(settings) ? INITIAL_CLUSTER_MANAGER_NODES_SETTING.getKey() : INITIAL_MASTER_NODES_SETTING.getKey();
        if (DiscoveryModule.isSingleNodeDiscovery(settings)) {
            if (INITIAL_CLUSTER_MANAGER_NODES_SETTING.existsOrFallbackExists(settings)) {
                throw new IllegalArgumentException("setting [" + initialClusterManagerSettingName + "] is not allowed when [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] is set to [single-node]");
            }
            if (!DiscoveryNode.isMasterNode(settings)) {
                throw new IllegalArgumentException("node with [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] set to [single-node] must be cluster-manager-eligible");
            }
            this.bootstrapRequirements = Collections.singleton(Node.NODE_NAME_SETTING.get(settings));
            this.unconfiguredBootstrapTimeout = null;
        } else {
            List<String> initialMasterNodes = INITIAL_CLUSTER_MANAGER_NODES_SETTING.get(settings);
            this.bootstrapRequirements = Collections.unmodifiableSet(new LinkedHashSet<String>(initialMasterNodes));
            if (this.bootstrapRequirements.size() != initialMasterNodes.size()) {
                throw new IllegalArgumentException("setting [" + initialClusterManagerSettingName + "] contains duplicates: " + initialMasterNodes);
            }
            this.unconfiguredBootstrapTimeout = ClusterBootstrapService.discoveryIsConfigured(settings) ? null : UNCONFIGURED_BOOTSTRAP_TIMEOUT_SETTING.get(settings);
        }
        this.transportService = transportService;
        this.discoveredNodesSupplier = discoveredNodesSupplier;
        this.isBootstrappedSupplier = isBootstrappedSupplier;
        this.votingConfigurationConsumer = votingConfigurationConsumer;
    }

    public static boolean discoveryIsConfigured(Settings settings) {
        return Stream.of(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING, DiscoveryModule.LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING, SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING, SettingsBasedSeedHostsProvider.LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING, INITIAL_CLUSTER_MANAGER_NODES_SETTING, INITIAL_MASTER_NODES_SETTING).anyMatch(s -> s.exists(settings));
    }

    void onFoundPeersUpdated() {
        Set<DiscoveryNode> nodes = this.getDiscoveredNodes();
        if (this.bootstrappingPermitted.get() && this.transportService.getLocalNode().isMasterNode() && !this.bootstrapRequirements.isEmpty() && !this.isBootstrappedSupplier.getAsBoolean() && nodes.stream().noneMatch(Coordinator::isZen1Node)) {
            Tuple<Set<DiscoveryNode>, List<String>> requirementMatchingResult;
            try {
                requirementMatchingResult = this.checkRequirements(nodes);
            }
            catch (IllegalStateException e) {
                logger.warn("bootstrapping cancelled", (Throwable)e);
                this.bootstrappingPermitted.set(false);
                return;
            }
            Set<DiscoveryNode> nodesMatchingRequirements = requirementMatchingResult.v1();
            List<String> unsatisfiedRequirements = requirementMatchingResult.v2();
            logger.trace("nodesMatchingRequirements={}, unsatisfiedRequirements={}, bootstrapRequirements={}", nodesMatchingRequirements, unsatisfiedRequirements, this.bootstrapRequirements);
            if (!nodesMatchingRequirements.contains(this.transportService.getLocalNode())) {
                logger.info("skipping cluster bootstrapping as local node does not match bootstrap requirements: {}", this.bootstrapRequirements);
                this.bootstrappingPermitted.set(false);
                return;
            }
            if (nodesMatchingRequirements.size() * 2 > this.bootstrapRequirements.size()) {
                this.startBootstrap(nodesMatchingRequirements, unsatisfiedRequirements);
            }
        }
    }

    void scheduleUnconfiguredBootstrap() {
        if (this.unconfiguredBootstrapTimeout == null) {
            return;
        }
        if (!this.transportService.getLocalNode().isMasterNode()) {
            return;
        }
        logger.info("no discovery configuration found, will perform best-effort cluster bootstrapping after [{}] unless existing cluster-manager is discovered", (Object)this.unconfiguredBootstrapTimeout);
        this.transportService.getThreadPool().scheduleUnlessShuttingDown(this.unconfiguredBootstrapTimeout, "generic", new Runnable(){

            @Override
            public void run() {
                Set<DiscoveryNode> discoveredNodes = ClusterBootstrapService.this.getDiscoveredNodes();
                List zen1Nodes = discoveredNodes.stream().filter(Coordinator::isZen1Node).collect(Collectors.toList());
                if (zen1Nodes.isEmpty()) {
                    logger.debug("performing best-effort cluster bootstrapping with {}", discoveredNodes);
                    ClusterBootstrapService.this.startBootstrap(discoveredNodes, Collections.emptyList());
                } else {
                    logger.info("avoiding best-effort cluster bootstrapping due to discovery of pre-7.0 nodes {}", zen1Nodes);
                }
            }

            public String toString() {
                return "unconfigured-discovery delayed bootstrap";
            }
        });
    }

    private Set<DiscoveryNode> getDiscoveredNodes() {
        return Stream.concat(Stream.of(this.transportService.getLocalNode()), StreamSupport.stream(this.discoveredNodesSupplier.get().spliterator(), false)).collect(Collectors.toSet());
    }

    private void startBootstrap(Set<DiscoveryNode> discoveryNodes, List<String> unsatisfiedRequirements) {
        assert (discoveryNodes.stream().allMatch(DiscoveryNode::isMasterNode)) : discoveryNodes;
        assert (discoveryNodes.stream().noneMatch(Coordinator::isZen1Node)) : discoveryNodes;
        assert (unsatisfiedRequirements.size() < discoveryNodes.size()) : discoveryNodes + " smaller than " + unsatisfiedRequirements;
        if (this.bootstrappingPermitted.compareAndSet(true, false)) {
            this.doBootstrap(new CoordinationMetadata.VotingConfiguration(Stream.concat(discoveryNodes.stream().map(DiscoveryNode::getId), unsatisfiedRequirements.stream().map(s -> BOOTSTRAP_PLACEHOLDER_PREFIX + s)).collect(Collectors.toSet())));
        }
    }

    public static boolean isBootstrapPlaceholder(String nodeId) {
        return nodeId.startsWith(BOOTSTRAP_PLACEHOLDER_PREFIX);
    }

    private void doBootstrap(final CoordinationMetadata.VotingConfiguration votingConfiguration) {
        assert (this.transportService.getLocalNode().isMasterNode());
        try {
            this.votingConfigurationConsumer.accept(votingConfiguration);
        }
        catch (Exception e) {
            logger.warn((Message)new ParameterizedMessage("exception when bootstrapping with {}, rescheduling", (Object)votingConfiguration), (Throwable)e);
            this.transportService.getThreadPool().scheduleUnlessShuttingDown(TimeValue.timeValueSeconds(10L), "generic", new Runnable(){

                @Override
                public void run() {
                    ClusterBootstrapService.this.doBootstrap(votingConfiguration);
                }

                public String toString() {
                    return "retry of failed bootstrapping with " + votingConfiguration;
                }
            });
        }
    }

    private static boolean matchesRequirement(DiscoveryNode discoveryNode, String requirement) {
        return discoveryNode.getName().equals(requirement) || discoveryNode.getAddress().toString().equals(requirement) || discoveryNode.getAddress().getAddress().equals(requirement);
    }

    private Tuple<Set<DiscoveryNode>, List<String>> checkRequirements(Set<DiscoveryNode> nodes) {
        HashSet<DiscoveryNode> selectedNodes = new HashSet<DiscoveryNode>();
        ArrayList<String> unmatchedRequirements = new ArrayList<String>();
        for (String bootstrapRequirement : this.bootstrapRequirements) {
            Set matchingNodes = nodes.stream().filter(n -> ClusterBootstrapService.matchesRequirement(n, bootstrapRequirement)).collect(Collectors.toSet());
            if (matchingNodes.size() == 0) {
                unmatchedRequirements.add(bootstrapRequirement);
            }
            if (matchingNodes.size() > 1) {
                throw new IllegalStateException("requirement [" + bootstrapRequirement + "] matches multiple nodes: " + matchingNodes);
            }
            for (DiscoveryNode matchingNode : matchingNodes) {
                if (selectedNodes.add(matchingNode)) continue;
                throw new IllegalStateException("node [" + matchingNode + "] matches multiple requirements: " + this.bootstrapRequirements.stream().filter(r -> ClusterBootstrapService.matchesRequirement(matchingNode, r)).collect(Collectors.toList()));
            }
        }
        return Tuple.tuple(selectedNodes, unmatchedRequirements);
    }
}

