/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.ApplyCommitRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.CoordinationStateRejectedException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.ElectionStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.Join;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PublishRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.PublishResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.StartJoinRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;

public class CoordinationState {
    private static final Logger logger = LogManager.getLogger(CoordinationState.class);
    private final DiscoveryNode localNode;
    private final ElectionStrategy electionStrategy;
    private final PersistedState persistedState;
    private VoteCollection joinVotes;
    private boolean startedJoinSinceLastReboot;
    private boolean electionWon;
    private long lastPublishedVersion;
    private CoordinationMetadata.VotingConfiguration lastPublishedConfiguration;
    private VoteCollection publishVotes;

    public CoordinationState(DiscoveryNode localNode, PersistedState persistedState, ElectionStrategy electionStrategy) {
        this.localNode = localNode;
        this.persistedState = persistedState;
        this.electionStrategy = electionStrategy;
        this.joinVotes = new VoteCollection();
        this.startedJoinSinceLastReboot = false;
        this.electionWon = false;
        this.lastPublishedVersion = 0L;
        this.lastPublishedConfiguration = persistedState.getLastAcceptedState().getLastAcceptedConfiguration();
        this.publishVotes = new VoteCollection();
    }

    public long getCurrentTerm() {
        return this.persistedState.getCurrentTerm();
    }

    public ClusterState getLastAcceptedState() {
        return this.persistedState.getLastAcceptedState();
    }

    public long getLastAcceptedTerm() {
        return this.getLastAcceptedState().term();
    }

    public long getLastAcceptedVersion() {
        return this.getLastAcceptedState().version();
    }

    private long getLastAcceptedVersionOrMetadataVersion() {
        return this.getLastAcceptedState().getVersionOrMetadataVersion();
    }

    public CoordinationMetadata.VotingConfiguration getLastCommittedConfiguration() {
        return this.getLastAcceptedState().getLastCommittedConfiguration();
    }

    public CoordinationMetadata.VotingConfiguration getLastAcceptedConfiguration() {
        return this.getLastAcceptedState().getLastAcceptedConfiguration();
    }

    public long getLastPublishedVersion() {
        return this.lastPublishedVersion;
    }

    public boolean electionWon() {
        return this.electionWon;
    }

    public boolean isElectionQuorum(VoteCollection joinVotes) {
        return this.electionStrategy.isElectionQuorum(this.localNode, this.getCurrentTerm(), this.getLastAcceptedTerm(), this.getLastAcceptedVersion(), this.getLastCommittedConfiguration(), this.getLastAcceptedConfiguration(), joinVotes);
    }

    public boolean isPublishQuorum(VoteCollection votes) {
        return votes.isQuorum(this.getLastCommittedConfiguration()) && votes.isQuorum(this.lastPublishedConfiguration);
    }

    public boolean containsJoinVoteFor(DiscoveryNode node) {
        return this.joinVotes.containsVoteFor(node);
    }

    boolean containsJoin(Join join) {
        return this.joinVotes.getJoins().contains(join);
    }

    public boolean joinVotesHaveQuorumFor(CoordinationMetadata.VotingConfiguration votingConfiguration) {
        return this.joinVotes.isQuorum(votingConfiguration);
    }

    public void setInitialState(ClusterState initialState) {
        CoordinationMetadata.VotingConfiguration lastAcceptedConfiguration = this.getLastAcceptedConfiguration();
        if (!lastAcceptedConfiguration.isEmpty()) {
            logger.debug("setInitialState: rejecting since last-accepted configuration is nonempty: {}", (Object)lastAcceptedConfiguration);
            throw new CoordinationStateRejectedException("initial state already set: last-accepted configuration now " + lastAcceptedConfiguration, new Object[0]);
        }
        assert (this.getLastAcceptedTerm() == 0L) : this.getLastAcceptedTerm();
        assert (this.getLastCommittedConfiguration().isEmpty()) : this.getLastCommittedConfiguration();
        assert (this.lastPublishedVersion == 0L) : this.lastPublishedVersion;
        assert (this.lastPublishedConfiguration.isEmpty()) : this.lastPublishedConfiguration;
        assert (!this.electionWon);
        assert (this.joinVotes.isEmpty()) : this.joinVotes;
        assert (this.publishVotes.isEmpty()) : this.publishVotes;
        assert (initialState.term() == 0L) : initialState + " should have term 0";
        assert (initialState.version() == this.getLastAcceptedVersion()) : initialState + " should have version " + this.getLastAcceptedVersion();
        assert (!initialState.getLastAcceptedConfiguration().isEmpty());
        assert (!initialState.getLastCommittedConfiguration().isEmpty());
        this.persistedState.setLastAcceptedState(initialState);
    }

    public Join handleStartJoin(StartJoinRequest startJoinRequest) {
        if (startJoinRequest.getTerm() <= this.getCurrentTerm()) {
            logger.debug("handleStartJoin: ignoring [{}] as term provided is not greater than current term [{}]", (Object)startJoinRequest, (Object)this.getCurrentTerm());
            throw new CoordinationStateRejectedException("incoming term " + startJoinRequest.getTerm() + " not greater than current term " + this.getCurrentTerm(), new Object[0]);
        }
        logger.debug("handleStartJoin: leaving term [{}] due to {}", (Object)this.getCurrentTerm(), (Object)startJoinRequest);
        if (!this.joinVotes.isEmpty()) {
            String reason = !this.electionWon ? "failed election" : (startJoinRequest.getSourceNode().equals(this.localNode) ? "bumping term" : "standing down as leader");
            logger.debug("handleStartJoin: discarding {}: {}", (Object)this.joinVotes, (Object)reason);
        }
        this.persistedState.setCurrentTerm(startJoinRequest.getTerm());
        assert (this.getCurrentTerm() == startJoinRequest.getTerm());
        this.lastPublishedVersion = 0L;
        this.lastPublishedConfiguration = this.getLastAcceptedConfiguration();
        this.startedJoinSinceLastReboot = true;
        this.electionWon = false;
        this.joinVotes = new VoteCollection();
        this.publishVotes = new VoteCollection();
        return new Join(this.localNode, startJoinRequest.getSourceNode(), this.getCurrentTerm(), this.getLastAcceptedTerm(), this.getLastAcceptedVersionOrMetadataVersion());
    }

    public boolean handleJoin(Join join) {
        assert (join.targetMatches(this.localNode)) : "handling join " + join + " for the wrong node " + this.localNode;
        if (join.getTerm() != this.getCurrentTerm()) {
            logger.debug("handleJoin: ignored join due to term mismatch (expected: [{}], actual: [{}])", (Object)this.getCurrentTerm(), (Object)join.getTerm());
            throw new CoordinationStateRejectedException("incoming term " + join.getTerm() + " does not match current term " + this.getCurrentTerm(), new Object[0]);
        }
        if (!this.startedJoinSinceLastReboot) {
            logger.debug("handleJoin: ignored join as term was not incremented yet after reboot");
            throw new CoordinationStateRejectedException("ignored join as term has not been incremented yet after reboot", new Object[0]);
        }
        long lastAcceptedTerm = this.getLastAcceptedTerm();
        if (join.getLastAcceptedTerm() > lastAcceptedTerm) {
            logger.debug("handleJoin: ignored join as joiner has a better last accepted term (expected: <=[{}], actual: [{}])", (Object)lastAcceptedTerm, (Object)join.getLastAcceptedTerm());
            throw new CoordinationStateRejectedException("incoming last accepted term " + join.getLastAcceptedTerm() + " of join higher than current last accepted term " + lastAcceptedTerm, new Object[0]);
        }
        if (join.getLastAcceptedTerm() == lastAcceptedTerm && join.getLastAcceptedVersion() > this.getLastAcceptedVersionOrMetadataVersion()) {
            logger.debug("handleJoin: ignored join as joiner has a better last accepted version (expected: <=[{}], actual: [{}]) in term {}", (Object)this.getLastAcceptedVersionOrMetadataVersion(), (Object)join.getLastAcceptedVersion(), (Object)lastAcceptedTerm);
            throw new CoordinationStateRejectedException("incoming last accepted version " + join.getLastAcceptedVersion() + " of join higher than current last accepted version " + this.getLastAcceptedVersionOrMetadataVersion() + " in term " + lastAcceptedTerm, new Object[0]);
        }
        if (this.getLastAcceptedConfiguration().isEmpty()) {
            logger.debug("handleJoin: rejecting join since this node has not received its initial configuration yet");
            throw new CoordinationStateRejectedException("rejecting join since this node has not received its initial configuration yet", new Object[0]);
        }
        boolean added = this.joinVotes.addJoinVote(join);
        boolean prevElectionWon = this.electionWon;
        this.electionWon = this.isElectionQuorum(this.joinVotes);
        assert (!prevElectionWon || this.electionWon) : "locaNode= " + this.localNode + ", join=" + join + ", joinVotes=" + this.joinVotes;
        logger.debug("handleJoin: added join {} from [{}] for election, electionWon={} lastAcceptedTerm={} lastAcceptedVersion={}", (Object)join, (Object)join.getSourceNode(), (Object)this.electionWon, (Object)lastAcceptedTerm, (Object)this.getLastAcceptedVersion());
        if (this.electionWon && !prevElectionWon) {
            logger.debug("handleJoin: election won in term [{}] with {}", (Object)this.getCurrentTerm(), (Object)this.joinVotes);
            this.lastPublishedVersion = this.getLastAcceptedVersion();
        }
        return added;
    }

    public PublishRequest handleClientValue(ClusterState clusterState) {
        if (!this.electionWon) {
            logger.debug("handleClientValue: ignored request as election not won");
            throw new CoordinationStateRejectedException("election not won", new Object[0]);
        }
        if (this.lastPublishedVersion != this.getLastAcceptedVersion()) {
            logger.debug("handleClientValue: cannot start publishing next value before accepting previous one");
            throw new CoordinationStateRejectedException("cannot start publishing next value before accepting previous one", new Object[0]);
        }
        if (clusterState.term() != this.getCurrentTerm()) {
            logger.debug("handleClientValue: ignored request due to term mismatch (expected: [term {} version >{}], actual: [term {} version {}])", (Object)this.getCurrentTerm(), (Object)this.lastPublishedVersion, (Object)clusterState.term(), (Object)clusterState.version());
            throw new CoordinationStateRejectedException("incoming term " + clusterState.term() + " does not match current term " + this.getCurrentTerm(), new Object[0]);
        }
        if (clusterState.version() <= this.lastPublishedVersion) {
            logger.debug("handleClientValue: ignored request due to version mismatch (expected: [term {} version >{}], actual: [term {} version {}])", (Object)this.getCurrentTerm(), (Object)this.lastPublishedVersion, (Object)clusterState.term(), (Object)clusterState.version());
            throw new CoordinationStateRejectedException("incoming cluster state version " + clusterState.version() + " lower or equal to last published version " + this.lastPublishedVersion, new Object[0]);
        }
        if (!clusterState.getLastAcceptedConfiguration().equals(this.getLastAcceptedConfiguration()) && !this.getLastCommittedConfiguration().equals(this.getLastAcceptedConfiguration())) {
            logger.debug("handleClientValue: only allow reconfiguration while not already reconfiguring");
            throw new CoordinationStateRejectedException("only allow reconfiguration while not already reconfiguring", new Object[0]);
        }
        if (!this.joinVotesHaveQuorumFor(clusterState.getLastAcceptedConfiguration())) {
            logger.debug("handleClientValue: only allow reconfiguration if joinVotes have quorum for new config");
            throw new CoordinationStateRejectedException("only allow reconfiguration if joinVotes have quorum for new config", new Object[0]);
        }
        assert (clusterState.getLastCommittedConfiguration().equals(this.getLastCommittedConfiguration())) : "last committed configuration should not change";
        this.lastPublishedVersion = clusterState.version();
        this.lastPublishedConfiguration = clusterState.getLastAcceptedConfiguration();
        this.publishVotes = new VoteCollection();
        logger.trace("handleClientValue: processing request for version [{}] and term [{}]", (Object)this.lastPublishedVersion, (Object)this.getCurrentTerm());
        return new PublishRequest(clusterState);
    }

    public PublishResponse handlePublishRequest(PublishRequest publishRequest) {
        ClusterState clusterState = publishRequest.getAcceptedState();
        if (clusterState.term() != this.getCurrentTerm()) {
            logger.debug("handlePublishRequest: ignored publish request due to term mismatch (expected: [{}], actual: [{}])", (Object)this.getCurrentTerm(), (Object)clusterState.term());
            throw new CoordinationStateRejectedException("incoming term " + clusterState.term() + " does not match current term " + this.getCurrentTerm(), new Object[0]);
        }
        if (clusterState.term() == this.getLastAcceptedTerm() && clusterState.version() <= this.getLastAcceptedVersion()) {
            if (clusterState.term() == 0L && !clusterState.nodes().getMasterNode().equals(this.getLastAcceptedState().nodes().getMasterNode())) {
                logger.debug("handling publish request in compatibility mode despite version mismatch (expected: >[{}], actual: [{}])", (Object)this.getLastAcceptedVersion(), (Object)clusterState.version());
            } else {
                logger.debug("handlePublishRequest: ignored publish request due to version mismatch (expected: >[{}], actual: [{}])", (Object)this.getLastAcceptedVersion(), (Object)clusterState.version());
                throw new CoordinationStateRejectedException("incoming version " + clusterState.version() + " lower or equal to current version " + this.getLastAcceptedVersion(), new Object[0]);
            }
        }
        logger.trace("handlePublishRequest: accepting publish request for version [{}] and term [{}]", (Object)clusterState.version(), (Object)clusterState.term());
        this.persistedState.setLastAcceptedState(clusterState);
        assert (this.getLastAcceptedState() == clusterState);
        return new PublishResponse(clusterState.term(), clusterState.version());
    }

    public Optional<ApplyCommitRequest> handlePublishResponse(DiscoveryNode sourceNode, PublishResponse publishResponse) {
        if (!this.electionWon) {
            logger.debug("handlePublishResponse: ignored response as election not won");
            throw new CoordinationStateRejectedException("election not won", new Object[0]);
        }
        if (publishResponse.getTerm() != this.getCurrentTerm()) {
            logger.debug("handlePublishResponse: ignored publish response due to term mismatch (expected: [{}], actual: [{}])", (Object)this.getCurrentTerm(), (Object)publishResponse.getTerm());
            throw new CoordinationStateRejectedException("incoming term " + publishResponse.getTerm() + " does not match current term " + this.getCurrentTerm(), new Object[0]);
        }
        if (publishResponse.getVersion() != this.lastPublishedVersion) {
            logger.debug("handlePublishResponse: ignored publish response due to version mismatch (expected: [{}], actual: [{}])", (Object)this.lastPublishedVersion, (Object)publishResponse.getVersion());
            throw new CoordinationStateRejectedException("incoming version " + publishResponse.getVersion() + " does not match current version " + this.lastPublishedVersion, new Object[0]);
        }
        logger.trace("handlePublishResponse: accepted publish response for version [{}] and term [{}] from [{}]", (Object)publishResponse.getVersion(), (Object)publishResponse.getTerm(), (Object)sourceNode);
        this.publishVotes.addVote(sourceNode);
        if (this.isPublishQuorum(this.publishVotes)) {
            logger.trace("handlePublishResponse: value committed for version [{}] and term [{}]", (Object)publishResponse.getVersion(), (Object)publishResponse.getTerm());
            return Optional.of(new ApplyCommitRequest(this.localNode, publishResponse.getTerm(), publishResponse.getVersion()));
        }
        return Optional.empty();
    }

    public void handleCommit(ApplyCommitRequest applyCommit) {
        if (applyCommit.getTerm() != this.getCurrentTerm()) {
            logger.debug("handleCommit: ignored commit request due to term mismatch (expected: [term {} version {}], actual: [term {} version {}])", (Object)this.getLastAcceptedTerm(), (Object)this.getLastAcceptedVersion(), (Object)applyCommit.getTerm(), (Object)applyCommit.getVersion());
            throw new CoordinationStateRejectedException("incoming term " + applyCommit.getTerm() + " does not match current term " + this.getCurrentTerm(), new Object[0]);
        }
        if (applyCommit.getTerm() != this.getLastAcceptedTerm()) {
            logger.debug("handleCommit: ignored commit request due to term mismatch (expected: [term {} version {}], actual: [term {} version {}])", (Object)this.getLastAcceptedTerm(), (Object)this.getLastAcceptedVersion(), (Object)applyCommit.getTerm(), (Object)applyCommit.getVersion());
            throw new CoordinationStateRejectedException("incoming term " + applyCommit.getTerm() + " does not match last accepted term " + this.getLastAcceptedTerm(), new Object[0]);
        }
        if (applyCommit.getVersion() != this.getLastAcceptedVersion()) {
            logger.debug("handleCommit: ignored commit request due to version mismatch (term {}, expected: [{}], actual: [{}])", (Object)this.getLastAcceptedTerm(), (Object)this.getLastAcceptedVersion(), (Object)applyCommit.getVersion());
            throw new CoordinationStateRejectedException("incoming version " + applyCommit.getVersion() + " does not match current version " + this.getLastAcceptedVersion(), new Object[0]);
        }
        logger.trace("handleCommit: applying commit request for term [{}] and version [{}]", (Object)applyCommit.getTerm(), (Object)applyCommit.getVersion());
        this.persistedState.markLastAcceptedStateAsCommitted();
        assert (this.getLastCommittedConfiguration().equals(this.getLastAcceptedConfiguration()));
    }

    public void invariant() {
        assert (this.getLastAcceptedTerm() <= this.getCurrentTerm());
        assert (this.electionWon() == this.isElectionQuorum(this.joinVotes));
        if (this.electionWon() ? !$assertionsDisabled && this.getLastPublishedVersion() < this.getLastAcceptedVersion() : !$assertionsDisabled && this.getLastPublishedVersion() != 0L) {
            throw new AssertionError();
        }
        assert (!this.electionWon() || this.startedJoinSinceLastReboot);
        assert (this.publishVotes.isEmpty() || this.electionWon());
    }

    public void close() throws IOException {
        this.persistedState.close();
    }

    public static interface PersistedState
    extends Closeable {
        public long getCurrentTerm();

        public ClusterState getLastAcceptedState();

        public void setCurrentTerm(long var1);

        public void setLastAcceptedState(ClusterState var1);

        default public void markLastAcceptedStateAsCommitted() {
            ClusterState lastAcceptedState = this.getLastAcceptedState();
            Metadata.Builder metadataBuilder = null;
            if (!lastAcceptedState.getLastAcceptedConfiguration().equals(lastAcceptedState.getLastCommittedConfiguration())) {
                CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(lastAcceptedState.coordinationMetadata()).lastCommittedConfiguration(lastAcceptedState.getLastAcceptedConfiguration()).build();
                metadataBuilder = Metadata.builder(lastAcceptedState.metadata());
                metadataBuilder.coordinationMetadata(coordinationMetadata);
            }
            if (!1.$assertionsDisabled && lastAcceptedState.metadata().clusterUUID().equals("_na_") && lastAcceptedState.term() != 0L) {
                throw new AssertionError((Object)("received cluster state with empty cluster uuid but not Zen1 BWC term: " + lastAcceptedState));
            }
            if (!lastAcceptedState.metadata().clusterUUID().equals("_na_") && !lastAcceptedState.metadata().clusterUUIDCommitted()) {
                if (metadataBuilder == null) {
                    metadataBuilder = Metadata.builder(lastAcceptedState.metadata());
                }
                metadataBuilder.clusterUUIDCommitted(true);
                if (lastAcceptedState.term() != 0L) {
                    logger.info("cluster UUID set to [{}]", (Object)lastAcceptedState.metadata().clusterUUID());
                }
            }
            if (metadataBuilder != null) {
                this.setLastAcceptedState(ClusterState.builder(lastAcceptedState).metadata(metadataBuilder).build());
            }
        }

        @Override
        default public void close() throws IOException {
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static class VoteCollection {
        private final Map<String, DiscoveryNode> nodes = new HashMap<String, DiscoveryNode>();
        private final Set<Join> joins = new HashSet<Join>();

        public boolean addVote(DiscoveryNode sourceNode) {
            return sourceNode.isMasterNode() && this.nodes.put(sourceNode.getId(), sourceNode) == null;
        }

        public boolean addJoinVote(Join join) {
            boolean added = this.addVote(join.getSourceNode());
            if (added) {
                this.joins.add(join);
            }
            return added;
        }

        public boolean isQuorum(CoordinationMetadata.VotingConfiguration configuration) {
            return configuration.hasQuorum(this.nodes.keySet());
        }

        public boolean containsVoteFor(DiscoveryNode node) {
            return this.nodes.containsKey(node.getId());
        }

        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        public Collection<DiscoveryNode> nodes() {
            return Collections.unmodifiableCollection(this.nodes.values());
        }

        public Set<Join> getJoins() {
            return Collections.unmodifiableSet(this.joins);
        }

        public String toString() {
            return "VoteCollection{votes=" + this.nodes.keySet() + ", joins=" + this.joins + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VoteCollection)) {
                return false;
            }
            VoteCollection that = (VoteCollection)o;
            if (!this.nodes.equals(that.nodes)) {
                return false;
            }
            return this.joins.equals(that.joins);
        }

        public int hashCode() {
            int result = this.nodes.hashCode();
            result = 31 * result + this.joins.hashCode();
            return result;
        }
    }
}

