/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.Client;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.GatewayService;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndexTemplateMissingException;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class TemplateUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TemplateUpgradeService.class);
    private final UnaryOperator<Map<String, IndexTemplateMetadata>> indexTemplateMetadataUpgraders;
    public final ClusterService clusterService;
    public final ThreadPool threadPool;
    public final Client client;
    final AtomicInteger upgradesInProgress = new AtomicInteger();
    private ImmutableOpenMap<String, IndexTemplateMetadata> lastTemplateMetadata;
    private static final ToXContent.Params PARAMS = new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true"));

    public TemplateUpgradeService(Client client, ClusterService clusterService, ThreadPool threadPool, Collection<UnaryOperator<Map<String, IndexTemplateMetadata>>> indexTemplateMetadataUpgraders) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexTemplateMetadataUpgraders = templates -> {
            Map upgradedTemplates = new HashMap(templates);
            for (UnaryOperator upgrader : indexTemplateMetadataUpgraders) {
                upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
            }
            return upgradedTemplates;
        };
        if (DiscoveryNode.isMasterNode(clusterService.getSettings())) {
            clusterService.addListener(this);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.upgradesInProgress.get() > 0) {
            return;
        }
        ImmutableOpenMap<String, IndexTemplateMetadata> templates = state.getMetadata().getTemplates();
        if (templates == this.lastTemplateMetadata) {
            return;
        }
        this.lastTemplateMetadata = templates;
        Optional<Tuple<Map<String, BytesReference>, Set<String>>> changes = this.calculateTemplateChanges(templates);
        if (changes.isPresent() && this.upgradesInProgress.compareAndSet(0, changes.get().v1().size() + changes.get().v2().size() + 1)) {
            logger.info("Starting template upgrade to version {}, {} templates will be updated and {} will be removed", (Object)Version.CURRENT, (Object)changes.get().v1().size(), (Object)changes.get().v2().size());
            assert (this.threadPool.getThreadContext().isSystemContext());
            this.threadPool.generic().execute(() -> this.upgradeTemplates((Map)((Tuple)changes.get()).v1(), (Set)((Tuple)changes.get()).v2()));
        }
    }

    void upgradeTemplates(Map<String, BytesReference> changes, Set<String> deletions) {
        MasterNodeRequest request;
        final AtomicBoolean anyUpgradeFailed = new AtomicBoolean(false);
        if (!this.threadPool.getThreadContext().isSystemContext()) {
            throw new IllegalStateException("template updates from the template upgrade service should always happen in a system context");
        }
        for (final Map.Entry<String, BytesReference> change : changes.entrySet()) {
            request = new PutIndexTemplateRequest(change.getKey()).source(change.getValue(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().putTemplate((PutIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error updating template [{}], request was not acknowledged", change.getKey());
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                @Override
                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    logger.warn((Message)new ParameterizedMessage("Error updating template [{}]", change.getKey()), (Throwable)e);
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
        for (final String template : deletions) {
            request = new DeleteIndexTemplateRequest(template);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().deleteTemplate((DeleteIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error deleting template [{}], request was not acknowledged", (Object)template);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                @Override
                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    if (!(e instanceof IndexTemplateMissingException)) {
                        logger.warn((Message)new ParameterizedMessage("Error deleting template [{}]", (Object)template), (Throwable)e);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryFinishUpgrade(AtomicBoolean anyUpgradeFailed) {
        assert (this.upgradesInProgress.get() > 0);
        if (this.upgradesInProgress.decrementAndGet() == 1) {
            try {
                if (anyUpgradeFailed.get()) {
                    logger.info("Templates were partially upgraded to version {}", (Object)Version.CURRENT);
                } else {
                    logger.info("Templates were upgraded successfully to version {}", (Object)Version.CURRENT);
                }
                ImmutableOpenMap<String, IndexTemplateMetadata> upgradedTemplates = this.clusterService.state().getMetadata().getTemplates();
                boolean changesRequired = this.calculateTemplateChanges(upgradedTemplates).isPresent();
                if (changesRequired) {
                    logger.warn("Templates are still reported as out of date after the upgrade. The template upgrade will be retried.");
                }
            }
            finally {
                int noMoreUpgrades = this.upgradesInProgress.decrementAndGet();
                assert (noMoreUpgrades == 0);
            }
        }
    }

    Optional<Tuple<Map<String, BytesReference>, Set<String>>> calculateTemplateChanges(ImmutableOpenMap<String, IndexTemplateMetadata> templates) {
        HashMap<String, IndexTemplateMetadata> existingMap = new HashMap<String, IndexTemplateMetadata>();
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : templates) {
            existingMap.put((String)objectObjectCursor.key, (IndexTemplateMetadata)objectObjectCursor.value);
        }
        Map upgradedMap = (Map)this.indexTemplateMetadataUpgraders.apply(existingMap);
        if (!upgradedMap.equals(existingMap)) {
            HashSet hashSet = new HashSet();
            HashMap changes = new HashMap();
            existingMap.keySet().forEach(s -> {
                if (!upgradedMap.containsKey(s)) {
                    deletes.add(s);
                }
            });
            upgradedMap.forEach((key, value) -> {
                if (!value.equals(existingMap.get(key))) {
                    changes.put(key, this.toBytesReference((IndexTemplateMetadata)value));
                }
            });
            return Optional.of(new Tuple(changes, hashSet));
        }
        return Optional.empty();
    }

    private BytesReference toBytesReference(IndexTemplateMetadata templateMetadata) {
        try {
            return XContentHelper.toXContent((builder, params) -> {
                IndexTemplateMetadata.Builder.toInnerXContentWithTypes(templateMetadata, builder, params);
                return builder;
            }, XContentType.JSON, PARAMS, false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot serialize template [" + templateMetadata.getName() + "]", ex);
        }
    }
}

