/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.IntSet;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diffable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MetadataIndexStateService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.GroupShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.PlainShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.PlainShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RecoverySource;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRoutingState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.iterable.Iterables;
import org.graylog.shaded.opensearch2.org.opensearch.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardNotFoundException;

public class RoutingTable
implements Iterable<IndexRoutingTable>,
Diffable<RoutingTable> {
    public static final RoutingTable EMPTY_ROUTING_TABLE = RoutingTable.builder().build();
    private final long version;
    private final ImmutableOpenMap<String, IndexRoutingTable> indicesRouting;
    private static Predicate<ShardRouting> ACTIVE_PREDICATE = ShardRouting::active;
    private static Predicate<ShardRouting> ASSIGNED_PREDICATE = ShardRouting::assignedToNode;

    private RoutingTable(long version, ImmutableOpenMap<String, IndexRoutingTable> indicesRouting) {
        this.version = version;
        this.indicesRouting = indicesRouting;
    }

    public static IndexShardRoutingTable shardRoutingTable(IndexRoutingTable indexRouting, int shardId) {
        IndexShardRoutingTable indexShard = indexRouting.shard(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(indexRouting.getIndex(), shardId));
        }
        return indexShard;
    }

    public long version() {
        return this.version;
    }

    @Override
    public Iterator<IndexRoutingTable> iterator() {
        return this.indicesRouting.valuesIt();
    }

    public boolean hasIndex(String index) {
        return this.indicesRouting.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexRoutingTable indexRouting = this.index(index.getName());
        return indexRouting != null && indexRouting.getIndex().equals(index);
    }

    public IndexRoutingTable index(String index) {
        return this.indicesRouting.get(index);
    }

    public IndexRoutingTable index(Index index) {
        return this.indicesRouting.get(index.getName());
    }

    public ImmutableOpenMap<String, IndexRoutingTable> indicesRouting() {
        return this.indicesRouting;
    }

    public ImmutableOpenMap<String, IndexRoutingTable> getIndicesRouting() {
        return this.indicesRouting();
    }

    public IndexShardRoutingTable shardRoutingTable(String index, int shardId) {
        IndexRoutingTable indexRouting = this.index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return RoutingTable.shardRoutingTable(indexRouting, shardId);
    }

    public IndexShardRoutingTable shardRoutingTable(ShardId shardId) {
        IndexRoutingTable indexRouting = this.index(shardId.getIndexName());
        if (indexRouting == null || !indexRouting.getIndex().equals(shardId.getIndex())) {
            throw new IndexNotFoundException(shardId.getIndex());
        }
        IndexShardRoutingTable shard = indexRouting.shard(shardId.id());
        if (shard == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shard;
    }

    @Nullable
    public ShardRouting getByAllocationId(ShardId shardId, String allocationId) {
        IndexRoutingTable indexRoutingTable = this.index(shardId.getIndexName());
        if (indexRoutingTable == null) {
            return null;
        }
        IndexShardRoutingTable shardRoutingTable = indexRoutingTable.shard(shardId.getId());
        return shardRoutingTable == null ? null : shardRoutingTable.getByAllocationId(allocationId);
    }

    public boolean validate(Metadata metadata) {
        for (IndexRoutingTable indexRoutingTable : this) {
            if (indexRoutingTable.validate(metadata)) continue;
            return false;
        }
        return true;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (IndexRoutingTable indexRoutingTable : this) {
            shards.addAll(indexRoutingTable.shardsWithState(state));
        }
        return shards;
    }

    public int shardsMatchingPredicateCount(Predicate<ShardRouting> predicate) {
        int count = 0;
        for (IndexRoutingTable indexRoutingTable : this) {
            count += indexRoutingTable.shardsMatchingPredicateCount(predicate);
        }
        return count;
    }

    public List<ShardRouting> allShards() {
        String[] indices;
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices = this.indicesRouting.keys().toArray(String.class)) {
            List<ShardRouting> allShardsIndex = this.allShards(index);
            shards.addAll(allShardsIndex);
        }
        return shards;
    }

    public List<ShardRouting> allShards(String index) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        IndexRoutingTable indexRoutingTable = this.index(index);
        if (indexRoutingTable == null) {
            throw new IndexNotFoundException(index);
        }
        for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
            for (ShardRouting shardRouting : indexShardRoutingTable) {
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public GroupShardsIterator<ShardIterator> allActiveShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, ACTIVE_PREDICATE);
    }

    public GroupShardsIterator<ShardIterator> allAssignedShardsGrouped(String[] indices, boolean includeEmpty) {
        return this.allSatisfyingPredicateShardsGrouped(indices, includeEmpty, ASSIGNED_PREDICATE);
    }

    private GroupShardsIterator<ShardIterator> allSatisfyingPredicateShardsGrouped(String[] indices, boolean includeEmpty, Predicate<ShardRouting> predicate) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (predicate.test(shardRouting)) {
                        set.add(shardRouting.shardsIt());
                        continue;
                    }
                    if (!includeEmpty) continue;
                    set.add(new PlainShardIterator(shardRouting.shardId(), Collections.emptyList()));
                }
            }
        }
        return GroupShardsIterator.sortAndCreate(set);
    }

    public ShardsIterator allShards(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, false);
    }

    public ShardsIterator allShardsIncludingRelocationTargets(String[] indices) {
        return this.allShardsSatisfyingPredicate(indices, shardRouting -> true, true);
    }

    private ShardsIterator allShardsSatisfyingPredicate(String[] indices, Predicate<ShardRouting> predicate, boolean includeRelocationTargets) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                for (ShardRouting shardRouting : indexShardRoutingTable) {
                    if (!predicate.test(shardRouting)) continue;
                    shards.add(shardRouting);
                    if (!includeRelocationTargets || !shardRouting.relocating()) continue;
                    shards.add(shardRouting.getTargetRelocatingShard());
                }
            }
        }
        return new PlainShardsIterator((List<ShardRouting>)shards);
    }

    public GroupShardsIterator<ShardIterator> activePrimaryShardsGrouped(String[] indices, boolean includeEmpty) {
        ArrayList<ShardIterator> set = new ArrayList<ShardIterator>();
        for (String index : indices) {
            IndexRoutingTable indexRoutingTable = this.index(index);
            if (indexRoutingTable == null) {
                throw new IndexNotFoundException(index);
            }
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                ShardRouting primary = indexShardRoutingTable.primaryShard();
                if (primary.active()) {
                    set.add(primary.shardsIt());
                    continue;
                }
                if (!includeEmpty) continue;
                set.add(new PlainShardIterator(primary.shardId(), Collections.emptyList()));
            }
        }
        return GroupShardsIterator.sortAndCreate(set);
    }

    @Override
    public Diff<RoutingTable> diff(RoutingTable previousState) {
        return new RoutingTableDiff(previousState, this);
    }

    public static Diff<RoutingTable> readDiffFrom(StreamInput in) throws IOException {
        return new RoutingTableDiff(in);
    }

    public static RoutingTable readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder();
        builder.version = in.readLong();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            IndexRoutingTable index = IndexRoutingTable.readFrom(in);
            builder.add(index);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeVInt(this.indicesRouting.size());
        for (ObjectCursor<IndexRoutingTable> objectCursor : this.indicesRouting.values()) {
            ((IndexRoutingTable)objectCursor.value).writeTo(out);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutingTable routingTable) {
        return new Builder(routingTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("routing_table (version ").append(this.version).append("):\n");
        for (ObjectObjectCursor<String, IndexRoutingTable> objectObjectCursor : this.indicesRouting) {
            sb.append(((IndexRoutingTable)objectObjectCursor.value).prettyPrint()).append('\n');
        }
        return sb.toString();
    }

    private static class RoutingTableDiff
    implements Diff<RoutingTable> {
        private final long version;
        private final Diff<ImmutableOpenMap<String, IndexRoutingTable>> indicesRouting;
        private static final DiffableUtils.DiffableValueReader<String, IndexRoutingTable> DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexRoutingTable::readFrom, IndexRoutingTable::readDiffFrom);

        RoutingTableDiff(RoutingTable before, RoutingTable after) {
            this.version = after.version;
            this.indicesRouting = DiffableUtils.diff(before.indicesRouting, after.indicesRouting, DiffableUtils.getStringKeySerializer());
        }

        RoutingTableDiff(StreamInput in) throws IOException {
            this.version = in.readLong();
            this.indicesRouting = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), DIFF_VALUE_READER);
        }

        @Override
        public RoutingTable apply(RoutingTable part) {
            return new RoutingTable(this.version, this.indicesRouting.apply(part.indicesRouting));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.version);
            this.indicesRouting.writeTo(out);
        }
    }

    public static class Builder {
        private long version;
        private ImmutableOpenMap.Builder<String, IndexRoutingTable> indicesRouting = ImmutableOpenMap.builder();

        public Builder() {
        }

        public Builder(RoutingTable routingTable) {
            this.version = routingTable.version;
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                this.indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
            }
        }

        public Builder updateNodes(long version, RoutingNodes routingNodes) {
            this.version = version;
            HashMap<String, IndexRoutingTable.Builder> indexRoutingTableBuilders = new HashMap<String, IndexRoutingTable.Builder>();
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRoutingEntry : routingNode) {
                    if (shardRoutingEntry.initializing() && shardRoutingEntry.relocatingNodeId() != null) continue;
                    Builder.addShard(indexRoutingTableBuilders, shardRoutingEntry);
                }
            }
            Iterable<ShardRouting> shardRoutingEntries = Iterables.concat(routingNodes.unassigned(), routingNodes.unassigned().ignored());
            for (ShardRouting shardRoutingEntry : shardRoutingEntries) {
                Builder.addShard(indexRoutingTableBuilders, shardRoutingEntry);
            }
            for (IndexRoutingTable.Builder indexBuilder : indexRoutingTableBuilders.values()) {
                this.add(indexBuilder);
            }
            return this;
        }

        private static void addShard(Map<String, IndexRoutingTable.Builder> indexRoutingTableBuilders, ShardRouting shardRoutingEntry) {
            Index index = shardRoutingEntry.index();
            IndexRoutingTable.Builder indexBuilder = indexRoutingTableBuilders.get(index.getName());
            if (indexBuilder == null) {
                indexBuilder = new IndexRoutingTable.Builder(index);
                indexRoutingTableBuilders.put(index.getName(), indexBuilder);
            }
            indexBuilder.addShard(shardRoutingEntry);
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            for (String index : indices) {
                IndexRoutingTable indexRoutingTable = this.indicesRouting.get(index);
                if (indexRoutingTable == null) continue;
                int currentNumberOfReplicas = indexRoutingTable.shards().get(0).size() - 1;
                IndexRoutingTable.Builder builder = new IndexRoutingTable.Builder(indexRoutingTable.getIndex());
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.addIndexShard(indexShardRoutingTable);
                }
                if (currentNumberOfReplicas < numberOfReplicas) {
                    for (int i = 0; i < numberOfReplicas - currentNumberOfReplicas; ++i) {
                        builder.addReplica();
                    }
                } else if (currentNumberOfReplicas > numberOfReplicas) {
                    for (int i = 0; i < currentNumberOfReplicas - numberOfReplicas; ++i) {
                        builder.removeReplica();
                    }
                }
                this.indicesRouting.put(index, builder.build());
            }
            return this;
        }

        public Builder addAsNew(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsNew(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsRecovery(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsRecovery(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromDangling(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN || MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata)) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsFromDangling(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromCloseToOpen(IndexMetadata indexMetadata) {
            if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsFromCloseToOpen(indexMetadata);
                this.add(indexRoutingBuilder);
            }
            return this;
        }

        public Builder addAsFromOpenToClose(IndexMetadata indexMetadata) {
            assert (MetadataIndexStateService.isIndexVerifiedBeforeClosed(indexMetadata));
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsFromOpenToClose(indexMetadata);
            return this.add(indexRoutingBuilder);
        }

        public Builder addAsRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsRestore(indexMetadata, recoverySource);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder addAsNewRestore(IndexMetadata indexMetadata, RecoverySource.SnapshotRecoverySource recoverySource, IntSet ignoreShards) {
            IndexRoutingTable.Builder indexRoutingBuilder = new IndexRoutingTable.Builder(indexMetadata.getIndex()).initializeAsNewRestore(indexMetadata, recoverySource, ignoreShards);
            this.add(indexRoutingBuilder);
            return this;
        }

        public Builder add(IndexRoutingTable indexRoutingTable) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.put(indexRoutingTable.getIndex().getName(), indexRoutingTable);
            return this;
        }

        public Builder add(IndexRoutingTable.Builder indexRoutingTableBuilder) {
            this.add(indexRoutingTableBuilder.build());
            return this;
        }

        public Builder remove(String index) {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            this.indicesRouting.remove(index);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public RoutingTable build() {
            if (this.indicesRouting == null) {
                throw new IllegalStateException("once build is called the builder cannot be reused");
            }
            RoutingTable table = new RoutingTable(this.version, this.indicesRouting.build());
            this.indicesRouting = null;
            return table;
        }
    }
}

