/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.Streams;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;

public class InputStreamStreamInput
extends StreamInput {
    private final InputStream is;
    private final long sizeLimit;

    public InputStreamStreamInput(InputStream is) {
        this(is, Long.MAX_VALUE);
    }

    public InputStreamStreamInput(InputStream is, long sizeLimit) {
        this.is = is;
        if (sizeLimit < 0L) {
            throw new IllegalArgumentException("size limit must be positive");
        }
        this.sizeLimit = sizeLimit;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.is.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int read = Streams.readFully(this.is, b, offset, len);
        if (read != len) {
            throw new EOFException();
        }
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    protected void ensureCanReadBytes(int length) throws EOFException {
        if ((long)length > this.sizeLimit) {
            throw new EOFException("tried to read: " + length + " bytes but this stream is limited to: " + this.sizeLimit);
        }
    }
}

