/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.xcontent;

import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentLocation;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static final LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);

    private LoggingDeprecationHandler() {
    }

    @Override
    public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_name", "{}Deprecated field [{}] used, expected [{}] instead", prefix, usedName, modernName);
    }

    @Override
    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_field", "{}Deprecated field [{}] used, replaced by [{}]", prefix, usedName, replacedWith);
    }

    @Override
    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.deprecate(usedName + "_deprecated_field", "{}Deprecated field [{}] used, this field is unused and will be removed entirely", prefix, usedName);
    }
}

