/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldDataService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardState;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public final class IndexWarmer {
    private static final Logger logger = LogManager.getLogger(IndexWarmer.class);
    private final List<Listener> listeners;

    IndexWarmer(ThreadPool threadPool, IndexFieldDataService indexFieldDataService, Listener ... listeners) {
        ArrayList<FieldDataWarmer> list = new ArrayList<FieldDataWarmer>();
        ExecutorService executor = threadPool.executor("warmer");
        list.add(new FieldDataWarmer(executor, indexFieldDataService));
        Collections.addAll(list, listeners);
        this.listeners = Collections.unmodifiableList(list);
    }

    void warm(OpenSearchDirectoryReader reader, IndexShard shard, IndexSettings settings) {
        if (shard.state() == IndexShardState.CLOSED) {
            return;
        }
        if (!settings.isWarmerEnabled()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{} top warming [{}]", (Object)shard.shardId(), (Object)reader);
        }
        shard.warmerService().onPreWarm();
        long time = System.nanoTime();
        ArrayList<TerminationHandle> terminationHandles = new ArrayList<TerminationHandle>();
        for (Listener listener : this.listeners) {
            terminationHandles.add(listener.warmReader(shard, reader));
        }
        for (TerminationHandle terminationHandle : terminationHandles) {
            try {
                terminationHandle.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("top warming has been interrupted", (Throwable)e);
                break;
            }
        }
        long took = System.nanoTime() - time;
        shard.warmerService().onPostWarm(took);
        if (shard.warmerService().logger().isTraceEnabled()) {
            shard.warmerService().logger().trace("top warming took [{}]", (Object)new TimeValue(took, TimeUnit.NANOSECONDS));
        }
    }

    private static class FieldDataWarmer
    implements Listener {
        private final Executor executor;
        private final IndexFieldDataService indexFieldDataService;

        FieldDataWarmer(Executor executor, IndexFieldDataService indexFieldDataService) {
            this.executor = executor;
            this.indexFieldDataService = indexFieldDataService;
        }

        @Override
        public TerminationHandle warmReader(IndexShard indexShard, OpenSearchDirectoryReader reader) {
            MapperService mapperService = indexShard.mapperService();
            HashMap<String, MappedFieldType> warmUpGlobalOrdinals = new HashMap<String, MappedFieldType>();
            for (MappedFieldType fieldType : mapperService.fieldTypes()) {
                String indexName = fieldType.name();
                if (!fieldType.eagerGlobalOrdinals()) continue;
                warmUpGlobalOrdinals.put(indexName, fieldType);
            }
            CountDownLatch latch = new CountDownLatch(warmUpGlobalOrdinals.size());
            for (MappedFieldType fieldType : warmUpGlobalOrdinals.values()) {
                this.executor.execute(() -> {
                    try {
                        long start = System.nanoTime();
                        IndexFieldData.Global ifd = (IndexFieldData.Global)this.indexFieldDataService.getForField(fieldType, this.indexFieldDataService.index().getName(), () -> {
                            throw new UnsupportedOperationException("search lookup not available when warming an index");
                        });
                        IndexFieldData global = ifd.loadGlobal(reader);
                        if (!reader.leaves().isEmpty()) {
                            global.load(reader.leaves().get(0));
                        }
                        if (indexShard.warmerService().logger().isTraceEnabled()) {
                            indexShard.warmerService().logger().trace("warmed global ordinals for [{}], took [{}]", (Object)fieldType.name(), (Object)TimeValue.timeValueNanos(System.nanoTime() - start));
                        }
                    }
                    catch (Exception e) {
                        indexShard.warmerService().logger().warn(() -> new ParameterizedMessage("failed to warm-up global ordinals for [{}]", (Object)fieldType.name()), (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            return () -> latch.await();
        }
    }

    public static interface Listener {
        public TerminationHandle warmReader(IndexShard var1, OpenSearchDirectoryReader var2);
    }

    public static interface TerminationHandle {
        public static final TerminationHandle NO_WAIT = () -> {};

        public void awaitTermination() throws InterruptedException;
    }
}

