/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.internal.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalyzerProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.AnalyzerScope;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.PreBuiltAnalyzerProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.PreConfiguredAnalysisComponent;
import org.graylog.shaded.opensearch2.org.opensearch.indices.analysis.PreBuiltAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.indices.analysis.PreBuiltCacheFactory;

public class PreBuiltAnalyzerProviderFactory
extends PreConfiguredAnalysisComponent<AnalyzerProvider<?>>
implements Closeable {
    private final Function<Version, Analyzer> create;
    private final PreBuiltAnalyzerProvider current;

    PreBuiltAnalyzerProviderFactory(String name, PreBuiltAnalyzers preBuiltAnalyzer) {
        super(name, new PreBuiltAnalyzersDelegateCache(name, preBuiltAnalyzer));
        this.create = preBuiltAnalyzer::getAnalyzer;
        this.current = new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, preBuiltAnalyzer.getAnalyzer(Version.CURRENT));
    }

    public PreBuiltAnalyzerProviderFactory(String name, PreBuiltCacheFactory.CachingStrategy cache, Supplier<Analyzer> create) {
        super(name, cache);
        this.create = version -> (Analyzer)create.get();
        this.current = new PreBuiltAnalyzerProvider(name, AnalyzerScope.INDICES, create.get());
    }

    @Override
    public AnalyzerProvider<?> get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = Version.indexCreated(settings);
        if (!Version.CURRENT.equals(versionCreated)) {
            return (AnalyzerProvider)super.get(indexSettings, environment, name, settings);
        }
        return this.current;
    }

    @Override
    protected AnalyzerProvider<?> create(Version version) {
        assert (!Version.CURRENT.equals(version));
        Analyzer analyzer = this.create.apply(version);
        return new PreBuiltAnalyzerProvider(this.getName(), AnalyzerScope.INDICES, analyzer);
    }

    @Override
    public void close() throws IOException {
        List closeables = this.cache.values().stream().map(AnalyzerProvider::get).collect(Collectors.toList());
        closeables.add(this.current.get());
        IOUtils.close(closeables);
    }

    static class PreBuiltAnalyzersDelegateCache
    implements PreBuiltCacheFactory.PreBuiltCache<AnalyzerProvider<?>> {
        private final String name;
        private final PreBuiltAnalyzers preBuiltAnalyzer;

        private PreBuiltAnalyzersDelegateCache(String name, PreBuiltAnalyzers preBuiltAnalyzer) {
            this.name = name;
            this.preBuiltAnalyzer = preBuiltAnalyzer;
        }

        @Override
        public AnalyzerProvider<?> get(Version version) {
            return new PreBuiltAnalyzerProvider(this.name, AnalyzerScope.INDICES, this.preBuiltAnalyzer.getAnalyzer(version));
        }

        @Override
        public void put(Version version, AnalyzerProvider<?> analyzerProvider) {
        }

        @Override
        public Collection<AnalyzerProvider<?>> values() {
            return this.preBuiltAnalyzer.getCache().values().stream().map(analyzer -> new PreBuiltAnalyzerProvider(this.name, AnalyzerScope.INDICES, (Analyzer)analyzer)).collect(Collectors.toList());
        }
    }
}

