/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.codec;

import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene91.Lucene91Codec;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CompletionFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene91Codec {
    private final Logger logger;
    private final MapperService mapperService;
    private final DocValuesFormat dvFormat = new Lucene90DocValuesFormat();
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene91Codec.Mode compressionMode, MapperService mapperService, Logger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType fieldType = this.mapperService.fieldType(field);
        if (fieldType == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", (Object)field);
        } else if (fieldType instanceof CompletionFieldMapper.CompletionFieldType) {
            return CompletionFieldMapper.CompletionFieldType.postingsFormat();
        }
        return super.getPostingsFormatForField(field);
    }

    @Override
    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.dvFormat;
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName("Lucene91").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene91");
        }
    }
}

