/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryCache;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryCachingPolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Similarity;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.MemorySizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.CodecService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParsedDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeases;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicyFactory;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndexingMemoryController;
import org.graylog.shaded.opensearch2.org.opensearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private final TranslogDeletionPolicyFactory translogDeletionPolicyFactory;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final ThreadPool threadPool;
    private final Engine.Warmer warmer;
    private final Store store;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    @Nullable
    private final List<ReferenceManager.RefreshListener> externalRefreshListener;
    @Nullable
    private final List<ReferenceManager.RefreshListener> internalRefreshListener;
    @Nullable
    private final Sort indexSort;
    @Nullable
    private final CircuitBreakerService circuitBreakerService;
    private final LongSupplier globalCheckpointSupplier;
    private final Supplier<RetentionLeases> retentionLeasesSupplier;
    private final LongSupplier primaryTermSupplier;
    private final TombstoneDocSupplier tombstoneDocSupplier;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", "default", s -> {
        switch (s) {
            case "default": 
            case "best_compression": 
            case "lucene_default": {
                return s;
            }
        }
        if (!Codec.availableCodecs().contains(s)) {
            throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression] but was: " + s);
        }
        return s;
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<Boolean> INDEX_OPTIMIZE_AUTO_GENERATED_IDS = Setting.boolSetting("index.optimize_auto_generated_id", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    private final TranslogConfig translogConfig;

    public Supplier<RetentionLeases> retentionLeasesSupplier() {
        return this.retentionLeasesSupplier;
    }

    public EngineConfig(ShardId shardId, ThreadPool threadPool, IndexSettings indexSettings, Engine.Warmer warmer, Store store, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> externalRefreshListener, List<ReferenceManager.RefreshListener> internalRefreshListener, Sort indexSort, CircuitBreakerService circuitBreakerService, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier, LongSupplier primaryTermSupplier, TombstoneDocSupplier tombstoneDocSupplier) {
        this(shardId, threadPool, indexSettings, warmer, store, mergePolicy, analyzer, similarity, codecService, eventListener, queryCache, queryCachingPolicy, translogConfig, null, flushMergesAfter, externalRefreshListener, internalRefreshListener, indexSort, circuitBreakerService, globalCheckpointSupplier, retentionLeasesSupplier, primaryTermSupplier, tombstoneDocSupplier);
    }

    EngineConfig(ShardId shardId, ThreadPool threadPool, IndexSettings indexSettings, Engine.Warmer warmer, Store store, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TranslogDeletionPolicyFactory translogDeletionPolicyFactory, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> externalRefreshListener, List<ReferenceManager.RefreshListener> internalRefreshListener, Sort indexSort, CircuitBreakerService circuitBreakerService, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier, LongSupplier primaryTermSupplier, TombstoneDocSupplier tombstoneDocSupplier) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.warmer = warmer == null ? a -> {} : warmer;
        this.store = store;
        this.mergePolicy = mergePolicy;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecService = codecService;
        this.eventListener = eventListener;
        this.codecName = indexSettings.getValue(INDEX_CODEC_SETTING);
        String escapeHatchProperty = "opensearch.index.memory.max_index_buffer_size";
        String maxBufferSize = System.getProperty("opensearch.index.memory.max_index_buffer_size");
        this.indexingBufferSize = maxBufferSize != null ? MemorySizeValue.parseBytesSizeValueOrHeapRatio(maxBufferSize, "opensearch.index.memory.max_index_buffer_size") : IndexingMemoryController.INDEX_BUFFER_SIZE_SETTING.get(indexSettings.getNodeSettings());
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
        this.translogDeletionPolicyFactory = translogDeletionPolicyFactory;
        this.flushMergesAfter = flushMergesAfter;
        this.externalRefreshListener = externalRefreshListener;
        this.internalRefreshListener = internalRefreshListener;
        this.indexSort = indexSort;
        this.circuitBreakerService = circuitBreakerService;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.retentionLeasesSupplier = Objects.requireNonNull(retentionLeasesSupplier);
        this.primaryTermSupplier = primaryTermSupplier;
        this.tombstoneDocSupplier = tombstoneDocSupplier;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Engine.Warmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public LongSupplier getGlobalCheckpointSupplier() {
        return this.globalCheckpointSupplier;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public List<ReferenceManager.RefreshListener> getExternalRefreshListener() {
        return this.externalRefreshListener;
    }

    public List<ReferenceManager.RefreshListener> getInternalRefreshListener() {
        return this.internalRefreshListener;
    }

    public boolean isAutoGeneratedIDsOptimizationEnabled() {
        return this.indexSettings.getValue(INDEX_OPTIMIZE_AUTO_GENERATED_IDS);
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    @Nullable
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public LongSupplier getPrimaryTermSupplier() {
        return this.primaryTermSupplier;
    }

    public TombstoneDocSupplier getTombstoneDocSupplier() {
        return this.tombstoneDocSupplier;
    }

    public TranslogDeletionPolicyFactory getCustomTranslogDeletionPolicyFactory() {
        return this.translogDeletionPolicyFactory;
    }

    public static interface TombstoneDocSupplier {
        public ParsedDocument newDeleteTombstoneDoc(String var1);

        public ParsedDocument newNoopTombstoneDoc(String var1);
    }
}

