/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.ParseException;
import java.util.Collections;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeometryFormat;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeometryParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.MapXContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.AbstractGeometryFieldMapper;

public class GeoShapeParser
extends AbstractGeometryFieldMapper.Parser<Geometry> {
    private final GeometryParser geometryParser;

    public GeoShapeParser(GeometryParser geometryParser) {
        this.geometryParser = geometryParser;
    }

    @Override
    public Geometry parse(XContentParser parser) throws IOException, ParseException {
        return this.geometryParser.parse(parser);
    }

    @Override
    public Object format(Geometry value, String format) {
        return this.geometryParser.geometryFormat(format).toXContentAsObject(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object parseAndFormatObject(Object value, String format) {
        try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("dummy_field", value), XContentType.JSON);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            GeometryFormat<Geometry> geometryFormat = this.geometryParser.geometryFormat(parser);
            if (geometryFormat.name().equals(format)) {
                Object object = value;
                return object;
            }
            Geometry geometry = geometryFormat.fromXContent(parser);
            Object object = this.format(geometry, format);
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

