/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateFormatter;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.index.analysis.IndexAnalyzers;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ContentPath;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappingLookup;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.similarity.SimilarityProvider;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptService;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract void validate(MappingLookup var1);

    protected static boolean hasIndexCreated(Settings settings) {
        return settings.hasValue(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey());
    }

    public static interface TypeParser {
        public Builder<?> parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final Function<String, SimilarityProvider> similarityLookupService;
            private final MapperService mapperService;
            private final Function<String, TypeParser> typeParsers;
            private final Version indexVersionCreated;
            private final Supplier<QueryShardContext> queryShardContextSupplier;
            private final DateFormatter dateFormatter;
            private final ScriptService scriptService;

            public ParserContext(Function<String, SimilarityProvider> similarityLookupService, MapperService mapperService, Function<String, TypeParser> typeParsers, Version indexVersionCreated, Supplier<QueryShardContext> queryShardContextSupplier, DateFormatter dateFormatter, ScriptService scriptService) {
                this.similarityLookupService = similarityLookupService;
                this.mapperService = mapperService;
                this.typeParsers = typeParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.queryShardContextSupplier = queryShardContextSupplier;
                this.dateFormatter = dateFormatter;
                this.scriptService = scriptService;
            }

            public IndexAnalyzers getIndexAnalyzers() {
                return this.mapperService.getIndexAnalyzers();
            }

            public Settings getSettings() {
                return this.mapperService.getIndexSettings().getSettings();
            }

            public SimilarityProvider getSimilarity(String name) {
                return this.similarityLookupService.apply(name);
            }

            public MapperService mapperService() {
                return this.mapperService;
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.apply(type);
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public Supplier<QueryShardContext> queryShardContextSupplier() {
                return this.queryShardContextSupplier;
            }

            public DateFormatter getDateFormatter() {
                return this.dateFormatter;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            protected Function<String, TypeParser> typeParsers() {
                return this.typeParsers;
            }

            protected Function<String, SimilarityProvider> similarityLookupService() {
                return this.similarityLookupService;
            }

            public ScriptService scriptService() {
                return this.scriptService;
            }

            public ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in);
            }

            static class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.similarityLookupService(), in.mapperService(), in.typeParsers(), in.indexVersionCreated(), in.queryShardContextSupplier(), in.getDateFormatter(), in.scriptService());
                }

                @Override
                public boolean isWithinMultiField() {
                    return true;
                }
            }
        }
    }

    public static abstract class Builder<T extends Builder> {
        public String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(BuilderContext var1);
    }

    public static class BuilderContext {
        private final Settings indexSettings;
        private final ContentPath contentPath;

        public BuilderContext(Settings indexSettings, ContentPath contentPath) {
            Objects.requireNonNull(indexSettings, "indexSettings is required");
            this.contentPath = contentPath;
            this.indexSettings = indexSettings;
        }

        public ContentPath path() {
            return this.contentPath;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public Version indexCreatedVersion() {
            return Version.indexCreated(this.indexSettings);
        }

        public Version indexCreatedVersionOrDefault(@Nullable Version defaultValue) {
            if (defaultValue == null || Mapper.hasIndexCreated(this.indexSettings)) {
                return this.indexCreatedVersion();
            }
            return defaultValue;
        }
    }
}

