/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.merge;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;

public class MergeStats
implements Writeable,
ToXContentFragment {
    private long total;
    private long totalTimeInMillis;
    private long totalNumDocs;
    private long totalSizeInBytes;
    private long current;
    private long currentNumDocs;
    private long currentSizeInBytes;
    private long totalStoppedTimeInMillis;
    private long totalThrottledTimeInMillis;
    private long totalBytesPerSecAutoThrottle;

    public MergeStats() {
    }

    public MergeStats(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.totalNumDocs = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
        this.current = in.readVLong();
        this.currentNumDocs = in.readVLong();
        this.currentSizeInBytes = in.readVLong();
        this.totalStoppedTimeInMillis = in.readVLong();
        this.totalThrottledTimeInMillis = in.readVLong();
        this.totalBytesPerSecAutoThrottle = in.readVLong();
    }

    public void add(long totalMerges, long totalMergeTime, long totalNumDocs, long totalSizeInBytes, long currentMerges, long currentNumDocs, long currentSizeInBytes, long stoppedTimeMillis, long throttledTimeMillis, double mbPerSecAutoThrottle) {
        this.total += totalMerges;
        this.totalTimeInMillis += totalMergeTime;
        this.totalNumDocs += totalNumDocs;
        this.totalSizeInBytes += totalSizeInBytes;
        this.current += currentMerges;
        this.currentNumDocs += currentNumDocs;
        this.currentSizeInBytes += currentSizeInBytes;
        this.totalStoppedTimeInMillis += stoppedTimeMillis;
        this.totalThrottledTimeInMillis += throttledTimeMillis;
        long bytesPerSecAutoThrottle = (long)(mbPerSecAutoThrottle * 1024.0 * 1024.0);
        this.totalBytesPerSecAutoThrottle = this.totalBytesPerSecAutoThrottle == Long.MAX_VALUE || bytesPerSecAutoThrottle == Long.MAX_VALUE ? Long.MAX_VALUE : (this.totalBytesPerSecAutoThrottle += bytesPerSecAutoThrottle);
    }

    public void add(MergeStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.current += mergeStats.current;
        this.currentNumDocs += mergeStats.currentNumDocs;
        this.currentSizeInBytes += mergeStats.currentSizeInBytes;
        this.addTotals(mergeStats);
    }

    public void addTotals(MergeStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.total += mergeStats.total;
        this.totalTimeInMillis += mergeStats.totalTimeInMillis;
        this.totalNumDocs += mergeStats.totalNumDocs;
        this.totalSizeInBytes += mergeStats.totalSizeInBytes;
        this.totalStoppedTimeInMillis += mergeStats.totalStoppedTimeInMillis;
        this.totalThrottledTimeInMillis += mergeStats.totalThrottledTimeInMillis;
        this.totalBytesPerSecAutoThrottle = this.totalBytesPerSecAutoThrottle == Long.MAX_VALUE || mergeStats.totalBytesPerSecAutoThrottle == Long.MAX_VALUE ? Long.MAX_VALUE : (this.totalBytesPerSecAutoThrottle += mergeStats.totalBytesPerSecAutoThrottle);
    }

    public long getTotal() {
        return this.total;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public long getTotalStoppedTimeInMillis() {
        return this.totalStoppedTimeInMillis;
    }

    public TimeValue getTotalStoppedTime() {
        return new TimeValue(this.totalStoppedTimeInMillis);
    }

    public long getTotalThrottledTimeInMillis() {
        return this.totalThrottledTimeInMillis;
    }

    public TimeValue getTotalThrottledTime() {
        return new TimeValue(this.totalThrottledTimeInMillis);
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public long getTotalNumDocs() {
        return this.totalNumDocs;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public ByteSizeValue getTotalSize() {
        return new ByteSizeValue(this.totalSizeInBytes);
    }

    public long getTotalBytesPerSecAutoThrottle() {
        return this.totalBytesPerSecAutoThrottle;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getCurrentNumDocs() {
        return this.currentNumDocs;
    }

    public long getCurrentSizeInBytes() {
        return this.currentSizeInBytes;
    }

    public ByteSizeValue getCurrentSize() {
        return new ByteSizeValue(this.currentSizeInBytes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("merges");
        builder.field("current", this.current);
        builder.field("current_docs", this.currentNumDocs);
        builder.humanReadableField("current_size_in_bytes", "current_size", this.getCurrentSize());
        builder.field("total", this.total);
        builder.humanReadableField("total_time_in_millis", "total_time", this.getTotalTime());
        builder.field("total_docs", this.totalNumDocs);
        builder.humanReadableField("total_size_in_bytes", "total_size", this.getTotalSize());
        builder.humanReadableField("total_stopped_time_in_millis", "total_stopped_time", this.getTotalStoppedTime());
        builder.humanReadableField("total_throttled_time_in_millis", "total_throttled_time", this.getTotalThrottledTime());
        if (builder.humanReadable() && this.totalBytesPerSecAutoThrottle != -1L) {
            builder.field("total_auto_throttle").value(new ByteSizeValue(this.totalBytesPerSecAutoThrottle).toString());
        }
        builder.field("total_auto_throttle_in_bytes", this.totalBytesPerSecAutoThrottle);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.totalNumDocs);
        out.writeVLong(this.totalSizeInBytes);
        out.writeVLong(this.current);
        out.writeVLong(this.currentNumDocs);
        out.writeVLong(this.currentSizeInBytes);
        out.writeVLong(this.totalStoppedTimeInMillis);
        out.writeVLong(this.totalThrottledTimeInMillis);
        out.writeVLong(this.totalBytesPerSecAutoThrottle);
    }

    static final class Fields {
        static final String MERGES = "merges";
        static final String CURRENT = "current";
        static final String CURRENT_DOCS = "current_docs";
        static final String CURRENT_SIZE = "current_size";
        static final String CURRENT_SIZE_IN_BYTES = "current_size_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String TOTAL_STOPPED_TIME = "total_stopped_time";
        static final String TOTAL_STOPPED_TIME_IN_MILLIS = "total_stopped_time_in_millis";
        static final String TOTAL_THROTTLED_TIME = "total_throttled_time";
        static final String TOTAL_THROTTLED_TIME_IN_MILLIS = "total_throttled_time_in_millis";
        static final String TOTAL_DOCS = "total_docs";
        static final String TOTAL_SIZE = "total_size";
        static final String TOTAL_SIZE_IN_BYTES = "total_size_in_bytes";
        static final String TOTAL_THROTTLE_BYTES_PER_SEC_IN_BYTES = "total_auto_throttle_in_bytes";
        static final String TOTAL_THROTTLE_BYTES_PER_SEC = "total_auto_throttle";

        Fields() {
        }
    }
}

