/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanClause;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.query.SpatialArgs;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.query.SpatialOperation;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapeRelation;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.SpatialStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.CircleBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.EnvelopeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.GeometryCollectionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.LineStringBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiLineStringBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiPointBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.MultiPolygonBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.PointBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.PolygonBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.DistanceUnit;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Circle;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Geometry;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryCollection;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.GeometryVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Line;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.LinearRing;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiLine;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPoint;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.MultiPolygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Point;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Polygon;
import org.graylog.shaded.opensearch2.org.opensearch.geometry.Rectangle;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ExistsQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchService;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Shape;

@Deprecated
public class LegacyGeoShapeQueryProcessor {
    private AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType ft;

    public LegacyGeoShapeQueryProcessor(AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType ft) {
        this.ft = ft;
    }

    public Query geoShapeQuery(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
        PrefixTreeStrategy prefixTreeStrategy;
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[geo-shape] queries on [PrefixTree geo shapes] cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        LegacyGeoShapeFieldMapper.GeoShapeFieldType shapeFieldType = (LegacyGeoShapeFieldMapper.GeoShapeFieldType)this.ft;
        SpatialStrategy spatialStrategy = shapeFieldType.strategy();
        if (strategy != null) {
            spatialStrategy = strategy;
        }
        if ((prefixTreeStrategy = shapeFieldType.resolvePrefixTreeStrategy(spatialStrategy)) instanceof RecursivePrefixTreeStrategy && relation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            Query exists = ExistsQueryBuilder.newFilter(context, fieldName, false);
            Query intersects = prefixTreeStrategy.makeQuery(LegacyGeoShapeQueryProcessor.getArgs(shape, ShapeRelation.INTERSECTS));
            bool.add(exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            return bool.build();
        }
        return prefixTreeStrategy.makeQuery(LegacyGeoShapeQueryProcessor.getArgs(shape, relation));
    }

    public static SpatialArgs getArgs(Geometry shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
            case CONTAINS: {
                return new SpatialArgs(SpatialOperation.Contains, LegacyGeoShapeQueryProcessor.buildS4J(shape));
            }
        }
        throw new IllegalArgumentException("invalid relation [" + relation + "]");
    }

    private static Shape buildS4J(Geometry geometry) {
        return LegacyGeoShapeQueryProcessor.geometryToShapeBuilder(geometry).buildS4J();
    }

    public static ShapeBuilder<?, ?, ?> geometryToShapeBuilder(Geometry geometry) {
        ShapeBuilder shapeBuilder = (ShapeBuilder)geometry.visit(new GeometryVisitor<ShapeBuilder<?, ?, ?>, RuntimeException>(){

            @Override
            public ShapeBuilder<?, ?, ?> visit(Circle circle) {
                return new CircleBuilder().center(circle.getLon(), circle.getLat()).radius(circle.getRadiusMeters(), DistanceUnit.METERS);
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(GeometryCollection<?> collection) {
                GeometryCollectionBuilder shapes = new GeometryCollectionBuilder();
                for (Geometry geometry : collection) {
                    shapes.shape((ShapeBuilder)geometry.visit(this));
                }
                return shapes;
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(Line line) {
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                for (int i = 0; i < line.length(); ++i) {
                    coordinates.add(new Coordinate(line.getX(i), line.getY(i), line.getZ(i)));
                }
                return new LineStringBuilder(coordinates);
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(LinearRing ring) {
                throw new UnsupportedOperationException("circle is not supported");
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(MultiLine multiLine) {
                MultiLineStringBuilder lines = new MultiLineStringBuilder();
                for (int i = 0; i < multiLine.size(); ++i) {
                    lines.linestring((LineStringBuilder)this.visit((Line)multiLine.get(i)));
                }
                return lines;
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(MultiPoint multiPoint) {
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point p = (Point)multiPoint.get(i);
                    coordinates.add(new Coordinate(p.getX(), p.getY(), p.getZ()));
                }
                return new MultiPointBuilder(coordinates);
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(MultiPolygon multiPolygon) {
                MultiPolygonBuilder polygons = new MultiPolygonBuilder();
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    polygons.polygon((PolygonBuilder)this.visit((Polygon)multiPolygon.get(i)));
                }
                return polygons;
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(Point point) {
                return new PointBuilder(point.getX(), point.getY());
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(Polygon polygon) {
                PolygonBuilder polygonBuilder = new PolygonBuilder((LineStringBuilder)this.visit((Line)polygon.getPolygon()), ShapeBuilder.Orientation.RIGHT, false);
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    polygonBuilder.hole((LineStringBuilder)this.visit((Line)polygon.getHole(i)));
                }
                return polygonBuilder;
            }

            @Override
            public ShapeBuilder<?, ?, ?> visit(Rectangle rectangle) {
                return new EnvelopeBuilder(new Coordinate(rectangle.getMinX(), rectangle.getMaxY()), new Coordinate(rectangle.getMaxX(), rectangle.getMinY()));
            }
        });
        return shapeBuilder;
    }
}

