/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.OpenSearchLeafReader;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        OpenSearchLeafReader esReader = OpenSearchLeafReader.getOpenSearchLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "OpenSearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        OpenSearchDirectoryReader esReader = OpenSearchDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap OpenSearchDirectoryReader");
    }
}

