/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.LongObjectHashMap;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.CountedBitSet;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogSnapshot;

final class MultiSnapshot
implements Translog.Snapshot {
    private final TranslogSnapshot[] translogs;
    private final int totalOperations;
    private int overriddenOperations;
    private final Closeable onClose;
    private int index;
    private final SeqNoSet seenSeqNo;

    MultiSnapshot(TranslogSnapshot[] translogs, Closeable onClose) {
        this.translogs = translogs;
        this.totalOperations = Arrays.stream(translogs).mapToInt(TranslogSnapshot::totalOperations).sum();
        this.overriddenOperations = 0;
        this.onClose = onClose;
        this.seenSeqNo = new SeqNoSet();
        this.index = translogs.length - 1;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    public int skippedOperations() {
        return Arrays.stream(this.translogs).mapToInt(TranslogSnapshot::skippedOperations).sum() + this.overriddenOperations;
    }

    @Override
    public Translog.Operation next() throws IOException {
        while (this.index >= 0) {
            Translog.Operation op;
            TranslogSnapshot current = this.translogs[this.index];
            while ((op = current.next()) != null) {
                if (op.seqNo() == -2L || !this.seenSeqNo.getAndSet(op.seqNo())) {
                    return op;
                }
                ++this.overriddenOperations;
            }
            --this.index;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.onClose.close();
    }

    static final class SeqNoSet {
        static final short BIT_SET_SIZE = 1024;
        private final LongObjectHashMap<CountedBitSet> bitSets = new LongObjectHashMap();

        SeqNoSet() {
        }

        boolean getAndSet(long value) {
            assert (value >= 0L);
            long key = value / 1024L;
            CountedBitSet bitset = this.bitSets.get(key);
            if (bitset == null) {
                bitset = new CountedBitSet(1024);
                this.bitSets.put(key, bitset);
            }
            int index = Math.toIntExact(value % 1024L);
            boolean wasOn = bitset.get(index);
            bitset.set(index);
            return wasOn;
        }
    }
}

