/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MetadataFieldMapper;

public final class MapperRegistry {
    private final Map<String, Mapper.TypeParser> mapperParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsersPre20;
    private final Function<String, Predicate<String>> fieldFilter;

    public MapperRegistry(Map<String, Mapper.TypeParser> mapperParsers, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, Predicate<String>> fieldFilter) {
        this.mapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, Mapper.TypeParser>(mapperParsers));
        this.metadataMapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers));
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> tempPre20 = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers);
        tempPre20.remove("_nested_path");
        this.metadataMapperParsersPre20 = Collections.unmodifiableMap(tempPre20);
        this.fieldFilter = fieldFilter;
    }

    public Map<String, Mapper.TypeParser> getMapperParsers() {
        return this.mapperParsers;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMapperParsers(Version indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter(Version.V_2_0_0) ? this.metadataMapperParsers : this.metadataMapperParsersPre20;
    }

    public boolean isMetadataField(Version indexCreatedVersion, String field) {
        return this.getMetadataMapperParsers(indexCreatedVersion).containsKey(field);
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.fieldFilter;
    }
}

