/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.recovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ListenableFuture;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.LocalCheckpointTracker;

public class RecoveryRequestTracker {
    private final Map<Long, ListenableFuture<Void>> ongoingRequests = Collections.synchronizedMap(new HashMap());
    private final LocalCheckpointTracker checkpointTracker = new LocalCheckpointTracker(-1L, -1L);

    @Nullable
    public synchronized ActionListener<Void> markReceivedAndCreateListener(final long requestSeqNo, final ActionListener<Void> listener) {
        if (this.checkpointTracker.hasProcessed(requestSeqNo)) {
            ListenableFuture<Void> existingFuture = this.ongoingRequests.get(requestSeqNo);
            if (existingFuture != null) {
                existingFuture.addListener(listener, OpenSearchExecutors.newDirectExecutorService());
            } else {
                listener.onResponse(null);
            }
            return null;
        }
        this.checkpointTracker.markSeqNoAsProcessed(requestSeqNo);
        ListenableFuture<Void> future = new ListenableFuture<Void>();
        this.ongoingRequests.put(requestSeqNo, future);
        future.addListener(new ActionListener<Void>(){

            @Override
            public void onResponse(Void v) {
                RecoveryRequestTracker.this.ongoingRequests.remove(requestSeqNo);
                listener.onResponse(v);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, OpenSearchExecutors.newDirectExecutorService());
        return future;
    }
}

