/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.persistent;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.client.OpenSearchClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.persistent.PersistentTaskResponse;
import org.graylog.shaded.opensearch2.org.opensearch.persistent.PersistentTasksClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class CompletionPersistentTaskAction
extends ActionType<PersistentTaskResponse> {
    public static final CompletionPersistentTaskAction INSTANCE = new CompletionPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/completion";

    private CompletionPersistentTaskAction() {
        super(NAME, PersistentTaskResponse::new);
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(CompletionPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver);
            this.persistentTasksClusterService = persistentTasksClusterService;
        }

        @Override
        protected String executor() {
            return "generic";
        }

        @Override
        protected PersistentTaskResponse read(StreamInput in) throws IOException {
            return new PersistentTaskResponse(in);
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        @Override
        protected final void masterOperation(Request request, ClusterState state, ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.completePersistentTask(request.taskId, request.allocationId, request.exception, ActionListener.delegateFailure(listener, (delegatedListener, task) -> delegatedListener.onResponse(new PersistentTaskResponse((PersistentTasksCustomMetadata.PersistentTask<?>)task))));
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(OpenSearchClient client, CompletionPersistentTaskAction action) {
            super(client, action, new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        private Exception exception;
        private long allocationId = -1L;

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskId = in.readString();
            this.allocationId = in.readLong();
            this.exception = in.readException();
        }

        public Request(String taskId, long allocationId, Exception exception) {
            this.taskId = taskId;
            this.exception = exception;
            this.allocationId = allocationId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeLong(this.allocationId);
            out.writeException(this.exception);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError("task id is missing", validationException);
            }
            if (this.allocationId < 0L) {
                validationException = ValidateActions.addValidationError("allocation id is negative or missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.taskId, request.taskId) && this.allocationId == request.allocationId && Objects.equals(this.exception, request.exception);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.allocationId, this.exception);
        }
    }
}

