/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Requests;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.SettingsFilter;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;

public class RestGetRepositoriesAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetRepositoriesAction.class);
    private final SettingsFilter settingsFilter;

    public RestGetRepositoriesAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "get_repositories_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_snapshot"), new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/{repository}")));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] repositories = request.paramAsStringArray("repository", Strings.EMPTY_ARRAY);
        GetRepositoriesRequest getRepositoriesRequest = Requests.getRepositoryRequest(repositories);
        getRepositoriesRequest.masterNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRepositoriesRequest.masterNodeTimeout()));
        RestGetRepositoriesAction.parseDeprecatedMasterTimeoutParameter(getRepositoriesRequest, request);
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().getRepositories(getRepositoriesRequest, new RestToXContentListener<GetRepositoriesResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

