/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoBoundingBox;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceParserHelper;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.GeoTileValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public class GeoTileGridValuesSourceBuilder
extends CompositeValuesSourceBuilder<GeoTileGridValuesSourceBuilder> {
    static final String TYPE = "geotile_grid";
    static final ValuesSourceRegistry.RegistryKey<GeoTileCompositeSuppier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<GeoTileCompositeSuppier>("geotile_grid", GeoTileCompositeSuppier.class);
    private static final ObjectParser<GeoTileGridValuesSourceBuilder, Void> PARSER = new ObjectParser("geotile_grid");
    private int precision = 7;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));

    static GeoTileGridValuesSourceBuilder parse(String name, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new GeoTileGridValuesSourceBuilder(name), null);
    }

    static void register(ValuesSourceRegistry.Builder builder) {
        builder.register(REGISTRY_KEY, CoreValuesSourceType.GEOPOINT, (valuesSourceConfig, precision, boundingBox, name, hasScript, format, missingBucket, missingOrder, order) -> {
            ValuesSource.GeoPoint geoPoint = (ValuesSource.GeoPoint)valuesSourceConfig.getValuesSource();
            MappedFieldType fieldType = valuesSourceConfig.fieldType();
            CellIdSource cellIdSource = new CellIdSource(geoPoint, precision, boundingBox, GeoTileUtils::longEncode);
            return new CompositeValuesSourceConfig(name, fieldType, cellIdSource, DocValueFormat.GEOTILE, order, missingBucket, missingOrder, hasScript, (bigArrays, reader, size, addRequestCircuitBreakerBytes, compositeValuesSourceConfig) -> {
                CellIdSource cis = (CellIdSource)compositeValuesSourceConfig.valuesSource();
                return new GeoTileValuesSource(bigArrays, compositeValuesSourceConfig.fieldType(), cis::longValues, LongUnaryOperator.identity(), compositeValuesSourceConfig.format(), compositeValuesSourceConfig.missingBucket(), compositeValuesSourceConfig.missingOrder(), size, compositeValuesSourceConfig.reverseMul());
            });
        }, false);
    }

    GeoTileGridValuesSourceBuilder(String name) {
        super(name);
    }

    GeoTileGridValuesSourceBuilder(StreamInput in) throws IOException {
        super(in);
        this.precision = in.readInt();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
            this.geoBoundingBox = new GeoBoundingBox(in);
        }
    }

    public GeoTileGridValuesSourceBuilder precision(int precision) {
        this.precision = GeoTileUtils.checkPrecisionRange(precision);
        return this;
    }

    public GeoTileGridValuesSourceBuilder geoBoundingBox(GeoBoundingBox geoBoundingBox) {
        this.geoBoundingBox = geoBoundingBox;
        return this;
    }

    @Override
    public GeoTileGridValuesSourceBuilder format(String format) {
        throw new IllegalArgumentException("[format] is not supported for [geotile_grid]");
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeInt(this.precision);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
            this.geoBoundingBox.writeTo(out);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("precision", this.precision);
        if (!this.geoBoundingBox.isUnbounded()) {
            this.geoBoundingBox.toXContent(builder, params);
        }
    }

    @Override
    String type() {
        return TYPE;
    }

    GeoBoundingBox geoBoundingBox() {
        return this.geoBoundingBox;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.geoBoundingBox);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoTileGridValuesSourceBuilder other = (GeoTileGridValuesSourceBuilder)obj;
        return Objects.equals(this.precision, other.precision) && Objects.equals(this.geoBoundingBox, other.geoBoundingBox);
    }

    @Override
    protected ValuesSourceType getDefaultValuesSourceType() {
        return CoreValuesSourceType.GEOPOINT;
    }

    @Override
    protected CompositeValuesSourceConfig innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config) throws IOException {
        return queryShardContext.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config).apply(config, this.precision, this.geoBoundingBox(), this.name, this.script() != null, this.format(), this.missingBucket(), this.missingOrder(), this.order());
    }

    static {
        PARSER.declareInt(GeoTileGridValuesSourceBuilder::precision, new ParseField("precision", new String[0]));
        PARSER.declareField((p, builder, context) -> builder.geoBoundingBox(GeoBoundingBox.parseBoundingBox(p)), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        CompositeValuesSourceParserHelper.declareValuesSourceFields(PARSER);
    }

    @FunctionalInterface
    public static interface GeoTileCompositeSuppier {
        public CompositeValuesSourceConfig apply(ValuesSourceConfig var1, int var2, GeoBoundingBox var3, String var4, boolean var5, String var6, boolean var7, MissingOrder var8, SortOrder var9);
    }
}

