/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.misc.search.DiversifiedTopDocsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocsCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BytesRefHash;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class DiversifiedMapSamplerAggregator
extends SamplerAggregator {
    private ValuesSource valuesSource;
    private int maxDocsPerValue;
    private BytesRefHash bucketOrds;

    DiversifiedMapSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata, ValuesSourceConfig valuesSourceConfig, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = valuesSourceConfig.getValuesSource();
        this.maxDocsPerValue = maxDocsPerValue;
        this.bucketOrds = new BytesRefHash(this.shardSize, context.bigArrays());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
        super.doClose();
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector(x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector(Consumer<Long> circuitBreakerConsumer) {
            super(DiversifiedMapSamplerAggregator.this.shardSize, DiversifiedMapSamplerAggregator.this.context.bigArrays(), circuitBreakerConsumer);
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            int minMaxDocsPerValue = Math.min(DiversifiedMapSamplerAggregator.this.maxDocsPerValue, DiversifiedMapSamplerAggregator.this.context.searcher().getIndexReader().maxDoc());
            return new ValuesDiversifiedTopDocsCollector(size, minMaxDocsPerValue);
        }

        @Override
        protected long getPriorityQueueSlotSize() {
            return SamplerAggregator.SCOREDOCKEY_SIZE;
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedBinaryDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedMapSamplerAggregator.this.valuesSource.bytesValues(context);
                }
                catch (IOException e) {
                    throw new OpenSearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){
                    private int docID = -1;

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        this.docID = target;
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public long longValue() throws IOException {
                        BytesRef bytes = ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                        long bucketOrdinal = DiversifiedMapSamplerAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                        }
                        return bucketOrdinal;
                    }
                };
            }
        }
    }
}

