/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.ObjectArray;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.TDigestState;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;

public class MedianAbsoluteDeviationAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private final double compression;
    private ObjectArray<TDigestState> valueSketches;

    MedianAbsoluteDeviationAggregator(String name, @Nullable ValuesSource valuesSource, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata, double compression) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = (ValuesSource.Numeric)valuesSource;
        this.format = Objects.requireNonNull(format);
        this.compression = compression;
        this.valueSketches = context.bigArrays().newObjectArray(1L);
    }

    private boolean hasDataForBucket(long bucketOrd) {
        return bucketOrd < this.valueSketches.size() && this.valueSketches.get(bucketOrd) != null;
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.hasDataForBucket(owningBucketOrd)) {
            return InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation(this.valueSketches.get(owningBucketOrd));
        }
        return Double.NaN;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                MedianAbsoluteDeviationAggregator.this.valueSketches = bigArrays.grow(MedianAbsoluteDeviationAggregator.this.valueSketches, bucket + 1L);
                TDigestState valueSketch = MedianAbsoluteDeviationAggregator.this.valueSketches.get(bucket);
                if (valueSketch == null) {
                    valueSketch = new TDigestState(MedianAbsoluteDeviationAggregator.this.compression);
                    MedianAbsoluteDeviationAggregator.this.valueSketches.set(bucket, valueSketch);
                }
                if (values.advanceExact(doc)) {
                    int valueCount = values.docValueCount();
                    for (int i = 0; i < valueCount; ++i) {
                        double value = values.nextValue();
                        valueSketch.add(value);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        if (this.hasDataForBucket(bucket)) {
            TDigestState valueSketch = this.valueSketches.get(bucket);
            return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, valueSketch);
        }
        return this.buildEmptyAggregation();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMedianAbsoluteDeviation(this.name, this.metadata(), this.format, new TDigestState(this.compression));
    }

    @Override
    public void doClose() {
        Releasables.close(this.valueSketches);
    }
}

