/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.CardinalityUpperBound;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.TopHitsAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.StoredFieldsContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchDocValuesContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FieldAndFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.ScriptFieldsContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SubSearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortAndFormats;

class TopHitsAggregatorFactory
extends AggregatorFactory {
    private final int from;
    private final int size;
    private final boolean explain;
    private final boolean version;
    private final boolean seqNoAndPrimaryTerm;
    private final boolean trackScores;
    private final Optional<SortAndFormats> sort;
    private final HighlightBuilder highlightBuilder;
    private final StoredFieldsContext storedFieldsContext;
    private final List<FieldAndFormat> docValueFields;
    private final List<FieldAndFormat> fetchFields;
    private final List<ScriptFieldsContext.ScriptField> scriptFields;
    private final FetchSourceContext fetchSourceContext;

    TopHitsAggregatorFactory(String name, int from, int size, boolean explain, boolean version, boolean seqNoAndPrimaryTerm, boolean trackScores, Optional<SortAndFormats> sort, HighlightBuilder highlightBuilder, StoredFieldsContext storedFieldsContext, List<FieldAndFormat> docValueFields, List<FieldAndFormat> fetchFields, List<ScriptFieldsContext.ScriptField> scriptFields, FetchSourceContext fetchSourceContext, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, queryShardContext, parent, subFactories, metadata);
        this.from = from;
        this.size = size;
        this.explain = explain;
        this.version = version;
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        this.trackScores = trackScores;
        this.sort = sort;
        this.highlightBuilder = highlightBuilder;
        this.storedFieldsContext = storedFieldsContext;
        this.docValueFields = docValueFields;
        this.fetchFields = fetchFields;
        this.scriptFields = scriptFields;
        this.fetchSourceContext = fetchSourceContext;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        SubSearchContext subSearchContext = new SubSearchContext(searchContext);
        subSearchContext.parsedQuery(searchContext.parsedQuery());
        subSearchContext.explain(this.explain);
        subSearchContext.version(this.version);
        subSearchContext.seqNoAndPrimaryTerm(this.seqNoAndPrimaryTerm);
        subSearchContext.trackScores(this.trackScores);
        subSearchContext.from(this.from);
        subSearchContext.size(this.size);
        if (this.sort.isPresent()) {
            subSearchContext.sort(this.sort.get());
        }
        if (this.storedFieldsContext != null) {
            subSearchContext.storedFieldsContext(this.storedFieldsContext);
        }
        if (this.docValueFields != null) {
            FetchDocValuesContext docValuesContext = FetchDocValuesContext.create(searchContext.mapperService()::simpleMatchToFullName, searchContext.mapperService().getIndexSettings().getMaxDocvalueFields(), this.docValueFields);
            subSearchContext.docValuesContext(docValuesContext);
        }
        if (this.fetchFields != null) {
            FetchFieldsContext fieldsContext = new FetchFieldsContext(this.fetchFields);
            subSearchContext.fetchFieldsContext(fieldsContext);
        }
        for (ScriptFieldsContext.ScriptField field : this.scriptFields) {
            subSearchContext.scriptFields().add(field);
        }
        if (this.fetchSourceContext != null) {
            subSearchContext.fetchSourceContext(this.fetchSourceContext);
        }
        if (this.highlightBuilder != null) {
            subSearchContext.highlight(this.highlightBuilder.build(searchContext.getQueryShardContext()));
        }
        return new TopHitsAggregator(searchContext.fetchPhase(), subSearchContext, this.name, searchContext, parent, metadata);
    }
}

