/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.builder;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;

public final class PointInTimeBuilder
implements Writeable,
ToXContentObject {
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField KEEP_ALIVE_FIELD = new ParseField("keep_alive", new String[0]);
    private static final ObjectParser<XContentParams, Void> PARSER = new ObjectParser(SearchSourceBuilder.POINT_IN_TIME.getPreferredName(), () -> new XContentParams());
    private final String id;
    private TimeValue keepAlive;

    public PointInTimeBuilder(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public PointInTimeBuilder(StreamInput in) throws IOException {
        this.id = in.readString();
        this.keepAlive = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalTimeValue(this.keepAlive);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SearchSourceBuilder.POINT_IN_TIME.getPreferredName());
        builder.field(ID_FIELD.getPreferredName(), this.id);
        if (this.keepAlive != null) {
            builder.field(KEEP_ALIVE_FIELD.getPreferredName(), this.keepAlive);
        }
        builder.endObject();
        return builder;
    }

    public static PointInTimeBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParams params = PARSER.parse(parser, null);
        if (params.id == null) {
            throw new IllegalArgumentException("point int time id is not provided");
        }
        return new PointInTimeBuilder(params.id).setKeepAlive(params.keepAlive);
    }

    public String getId() {
        return this.id;
    }

    public PointInTimeBuilder setKeepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Nullable
    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointInTimeBuilder that = (PointInTimeBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.keepAlive);
    }

    static {
        PARSER.declareString((params, id) -> {
            params.id = id;
        }, ID_FIELD);
        PARSER.declareField((params, keepAlive) -> {
            params.keepAlive = keepAlive;
        }, (p, c) -> TimeValue.parseTimeValue(p.text(), KEEP_ALIVE_FIELD.getPreferredName()), KEEP_ALIVE_FIELD, ObjectParser.ValueType.STRING);
    }

    private static final class XContentParams {
        private String id;
        private TimeValue keepAlive;

        private XContentParams() {
        }
    }
}

