/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.lookup;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.DocLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.FieldsLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.LeafSearchLookup;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SourceLookup;

public class SearchLookup {
    private static final int MAX_FIELD_CHAIN_DEPTH = 5;
    private final Set<String> fieldChain;
    private final DocLookup docMap;
    private final SourceLookup sourceLookup;
    private final FieldsLookup fieldsLookup;
    private final BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup;

    public SearchLookup(MapperService mapperService, BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup) {
        this.fieldChain = Collections.emptySet();
        this.docMap = new DocLookup(mapperService, fieldType -> (IndexFieldData)fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())));
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService);
        this.fieldDataLookup = fieldDataLookup;
    }

    private SearchLookup(SearchLookup searchLookup, Set<String> fieldChain) {
        this.fieldChain = Collections.unmodifiableSet(fieldChain);
        this.docMap = new DocLookup(searchLookup.docMap.mapperService(), fieldType -> searchLookup.fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())));
        this.sourceLookup = searchLookup.sourceLookup;
        this.fieldsLookup = searchLookup.fieldsLookup;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
    }

    public final SearchLookup forkAndTrackFieldReferences(String field) {
        Objects.requireNonNull(field, "field cannot be null");
        LinkedHashSet<String> newFieldChain = new LinkedHashSet<String>(this.fieldChain);
        if (!newFieldChain.add(field)) {
            String message = String.join((CharSequence)" -> ", newFieldChain) + " -> " + field;
            throw new IllegalArgumentException("Cyclic dependency detected while resolving runtime fields: " + message);
        }
        if (newFieldChain.size() > 5) {
            throw new IllegalArgumentException("Field requires resolving too many dependent fields: " + String.join((CharSequence)" -> ", newFieldChain));
        }
        return new SearchLookup(this, newFieldChain);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, this.docMap.getLeafDocLookup(context), this.sourceLookup, this.fieldsLookup.getLeafFieldsLookup(context));
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }
}

