/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.profile.aggregation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.AbstractProfiler;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.aggregation.InternalAggregationProfileTree;

public class AggregationProfiler
extends AbstractProfiler<AggregationProfileBreakdown, Aggregator> {
    private final Map<List<String>, AggregationProfileBreakdown> profileBreakdownLookup = new HashMap<List<String>, AggregationProfileBreakdown>();

    public AggregationProfiler() {
        super(new InternalAggregationProfileTree());
    }

    @Override
    public AggregationProfileBreakdown getQueryBreakdown(Aggregator agg) {
        List<String> path = AggregationProfiler.getAggregatorPath(agg);
        AggregationProfileBreakdown aggregationProfileBreakdown = this.profileBreakdownLookup.get(path);
        if (aggregationProfileBreakdown == null) {
            aggregationProfileBreakdown = (AggregationProfileBreakdown)super.getQueryBreakdown(agg);
            this.profileBreakdownLookup.put(path, aggregationProfileBreakdown);
        }
        return aggregationProfileBreakdown;
    }

    public static List<String> getAggregatorPath(Aggregator agg) {
        LinkedList<String> path = new LinkedList<String>();
        while (agg != null) {
            path.addFirst(agg.name());
            agg = agg.parent();
        }
        return path;
    }
}

