/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.query;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectionTerminatedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FilterCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.FilterLeafCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafCollector;

public class EarlyTerminatingCollector
extends FilterCollector {
    private final int maxCountHits;
    private int numCollected;
    private boolean forceTermination;
    private boolean earlyTerminated;

    EarlyTerminatingCollector(Collector delegate, int maxCountHits, boolean forceTermination) {
        super(delegate);
        this.maxCountHits = maxCountHits;
        this.forceTermination = forceTermination;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.numCollected >= this.maxCountHits) {
            this.earlyTerminated = true;
            if (this.forceTermination) {
                throw new EarlyTerminationException("early termination [CountBased]");
            }
            throw new CollectionTerminatedException();
        }
        return new FilterLeafCollector(super.getLeafCollector(context)){

            @Override
            public void collect(int doc) throws IOException {
                if (++EarlyTerminatingCollector.this.numCollected > EarlyTerminatingCollector.this.maxCountHits) {
                    EarlyTerminatingCollector.this.earlyTerminated = true;
                    if (EarlyTerminatingCollector.this.forceTermination) {
                        throw new EarlyTerminationException("early termination [CountBased]");
                    }
                    throw new CollectionTerminatedException();
                }
                super.collect(doc);
            }
        };
    }

    public boolean hasEarlyTerminated() {
        return this.earlyTerminated;
    }

    static final class EarlyTerminationException
    extends RuntimeException {
        EarlyTerminationException(String msg) {
            super(msg);
        }
    }
}

