/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.snapshots;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;

public class SnapshotUtils {
    public static List<String> filterIndices(List<String> availableIndices, String[] selectedIndices, IndicesOptions indicesOptions) {
        if (IndexNameExpressionResolver.isAllIndices(Arrays.asList(selectedIndices))) {
            return availableIndices;
        }
        HashSet<Object> result = null;
        for (int i = 0; i < selectedIndices.length; ++i) {
            String indexOrPattern = selectedIndices[i];
            boolean add = true;
            if (!indexOrPattern.isEmpty()) {
                if (availableIndices.contains(indexOrPattern)) {
                    if (result == null) {
                        result = new HashSet<String>();
                    }
                    result.add(indexOrPattern);
                    continue;
                }
                if (indexOrPattern.charAt(0) == '+') {
                    add = true;
                    indexOrPattern = indexOrPattern.substring(1);
                    if (i == 0) {
                        result = new HashSet();
                    }
                } else if (indexOrPattern.charAt(0) == '-') {
                    if (i == 0) {
                        result = new HashSet<String>(availableIndices);
                    }
                    add = false;
                    indexOrPattern = indexOrPattern.substring(1);
                }
            }
            if (indexOrPattern.isEmpty() || !Regex.isSimpleMatchPattern(indexOrPattern)) {
                if (!availableIndices.contains(indexOrPattern)) {
                    if (!indicesOptions.ignoreUnavailable()) {
                        throw new IndexNotFoundException(indexOrPattern);
                    }
                    if (result != null) continue;
                    result = new HashSet<String>(availableIndices.subList(0, i));
                    continue;
                }
                if (result == null) continue;
                if (add) {
                    result.add(indexOrPattern);
                    continue;
                }
                result.remove(indexOrPattern);
                continue;
            }
            if (result == null) {
                result = new HashSet<String>(availableIndices.subList(0, i));
            }
            boolean found = false;
            for (String index : availableIndices) {
                if (!Regex.simpleMatch(indexOrPattern, index)) continue;
                found = true;
                if (add) {
                    result.add(index);
                    continue;
                }
                result.remove(index);
            }
            if (found || indicesOptions.allowNoIndices()) continue;
            throw new IndexNotFoundException(indexOrPattern);
        }
        if (result == null) {
            return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(selectedIndices)));
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }
}

