/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ContextParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;

public final class TaskId
implements Writeable {
    public static final TaskId EMPTY_TASK_ID = new TaskId();
    private final String nodeId;
    private final long id;

    public TaskId(String nodeId, long id) {
        if (nodeId.isEmpty()) {
            throw new IllegalArgumentException("0 length nodeIds are reserved for EMPTY_TASK_ID and are otherwise invalid.");
        }
        this.nodeId = nodeId;
        this.id = id;
    }

    private TaskId() {
        this.nodeId = "";
        this.id = -1L;
    }

    public TaskId(String taskId) {
        if (Strings.hasLength(taskId) && !"unset".equals(taskId)) {
            String[] s = Strings.split(taskId, ":");
            if (s == null || s.length != 2) {
                throw new IllegalArgumentException("malformed task id " + taskId);
            }
            this.nodeId = s[0];
            try {
                this.id = Long.parseLong(s[1]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("malformed task id " + taskId, ex);
            }
        } else {
            this.nodeId = "";
            this.id = -1L;
        }
    }

    public static TaskId readFromStream(StreamInput in) throws IOException {
        String nodeId = in.readString();
        if (nodeId.isEmpty()) {
            return EMPTY_TASK_ID;
        }
        return new TaskId(nodeId, in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        if (this.nodeId.isEmpty()) {
            return;
        }
        out.writeLong(this.id);
    }

    public static ContextParser<Void, TaskId> parser() {
        return (p, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new TaskId(p.text());
            }
            throw new OpenSearchParseException("Expected a string but found [{}] instead", new Object[]{p.currentToken()});
        };
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getId() {
        return this.id;
    }

    public boolean isSet() {
        return this.id != -1L;
    }

    public String toString() {
        if (this.isSet()) {
            return this.nodeId + ":" + this.id;
        }
        return "unset";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskId taskId = (TaskId)o;
        if (this.id != taskId.id) {
            return false;
        }
        return this.nodeId.equals(taskId.nodeId);
    }

    public int hashCode() {
        int result = this.nodeId.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

