/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.MapBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.component.LifecycleComponent;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.BoundTransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.TransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentMapLong;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectionProfile;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportMessageListener;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportStats;

public interface Transport
extends LifecycleComponent {
    default public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        this.getRequestHandlers().registerHandler(reg);
    }

    public void setMessageListener(TransportMessageListener var1);

    default public void setSlowLogThreshold(TimeValue slowLogThreshold) {
    }

    default public boolean isSecure() {
        return false;
    }

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1) throws UnknownHostException;

    public List<String> getDefaultSeedAddresses();

    public void openConnection(DiscoveryNode var1, ConnectionProfile var2, ActionListener<Connection> var3);

    public TransportStats getStats();

    public ResponseHandlers getResponseHandlers();

    public RequestHandlers getRequestHandlers();

    public static final class RequestHandlers {
        private volatile Map<String, RequestHandlerRegistry<? extends TransportRequest>> requestHandlers = Collections.emptyMap();

        synchronized <Request extends TransportRequest> void registerHandler(RequestHandlerRegistry<Request> reg) {
            if (this.requestHandlers.containsKey(reg.getAction())) {
                throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
            }
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put(reg.getAction(), reg).immutableMap();
        }

        public synchronized <Request extends TransportRequest> void forceRegister(RequestHandlerRegistry<Request> reg) {
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put(reg.getAction(), reg).immutableMap();
        }

        public <T extends TransportRequest> RequestHandlerRegistry<T> getHandler(String action) {
            return this.requestHandlers.get(action);
        }
    }

    public static final class ResponseHandlers {
        private final ConcurrentMapLong<ResponseContext<? extends TransportResponse>> handlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
        private final AtomicLong requestIdGenerator = new AtomicLong();

        public boolean contains(long requestId) {
            return this.handlers.containsKey(requestId);
        }

        public ResponseContext<? extends TransportResponse> remove(long requestId) {
            return this.handlers.remove(requestId);
        }

        public long add(ResponseContext<? extends TransportResponse> holder) {
            long requestId = this.newRequestId();
            ResponseContext<? extends TransportResponse> existing = this.handlers.put(requestId, holder);
            assert (existing == null) : "request ID already in use: " + requestId;
            return requestId;
        }

        long newRequestId() {
            return this.requestIdGenerator.incrementAndGet();
        }

        public List<ResponseContext<? extends TransportResponse>> prune(Predicate<ResponseContext<? extends TransportResponse>> predicate) {
            ArrayList<ResponseContext<? extends TransportResponse>> holders = new ArrayList<ResponseContext<? extends TransportResponse>>();
            for (Map.Entry entry : this.handlers.entrySet()) {
                ResponseContext remove;
                ResponseContext holder = (ResponseContext)entry.getValue();
                if (!predicate.test(holder) || (remove = (ResponseContext)this.handlers.remove(entry.getKey())) == null) continue;
                holders.add(holder);
            }
            return holders;
        }

        public TransportResponseHandler<? extends TransportResponse> onResponseReceived(long requestId, TransportMessageListener listener) {
            ResponseContext<? extends TransportResponse> context = this.handlers.remove(requestId);
            listener.onResponseReceived(requestId, context);
            if (context == null) {
                return null;
            }
            return context.handler();
        }
    }

    public static final class ResponseContext<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final Connection connection;
        private final String action;

        ResponseContext(TransportResponseHandler<T> handler, Connection connection, String action) {
            this.handler = handler;
            this.connection = connection;
            this.action = action;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public Connection connection() {
            return this.connection;
        }

        public String action() {
            return this.action;
        }
    }

    public static interface Connection
    extends Closeable {
        public DiscoveryNode getNode();

        public void sendRequest(long var1, String var3, TransportRequest var4, TransportRequestOptions var5) throws IOException, TransportException;

        public void addCloseListener(ActionListener<Void> var1);

        public boolean isClosed();

        default public Version getVersion() {
            return this.getNode().getVersion();
        }

        default public Object getCacheKey() {
            return this;
        }

        @Override
        public void close();
    }
}

