/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient;

import java.io.File;
import java.net.InetSocketAddress;
import org.graylog2.gelfclient.GelfTransports;

public class GelfConfiguration {
    private static final int DEFAULT_PORT = 12201;
    private static final String DEFAULT_HOSTNAME = "127.0.0.1";
    private final String hostname;
    private final int port;
    private GelfTransports transport = GelfTransports.TCP;
    private int queueSize = 512;
    private boolean tlsEnabled = false;
    private File tlsTrustCertChainFile = null;
    private boolean tlsCertVerificationEnabled = true;
    private int reconnectDelay = 500;
    private int connectTimeout = 1000;
    private boolean tcpNoDelay = false;
    private int sendBufferSize = -1;

    public GelfConfiguration(String hostname, int port) {
        this.hostname = this.checkHostname(hostname);
        this.port = this.checkPort(port);
    }

    public GelfConfiguration(InetSocketAddress remoteAddress) {
        this(remoteAddress.getHostString(), remoteAddress.getPort());
    }

    public GelfConfiguration(String hostname) {
        this(hostname, 12201);
    }

    public GelfConfiguration(int port) {
        this(DEFAULT_HOSTNAME, port);
    }

    public GelfConfiguration() {
        this(DEFAULT_HOSTNAME, 12201);
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    public GelfTransports getTransport() {
        return this.transport;
    }

    public GelfConfiguration transport(GelfTransports transport) {
        this.transport = transport;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public GelfConfiguration queueSize(int size) {
        this.queueSize = size;
        return this;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public GelfConfiguration enableTls() {
        this.tlsEnabled = true;
        return this;
    }

    public GelfConfiguration disableTls() {
        this.tlsEnabled = false;
        return this;
    }

    public File getTlsTrustCertChainFile() {
        return this.tlsTrustCertChainFile;
    }

    public GelfConfiguration tlsTrustCertChainFile(File tlsTrustCertChainFile) {
        this.tlsTrustCertChainFile = tlsTrustCertChainFile;
        return this;
    }

    public boolean isTlsCertVerificationEnabled() {
        return this.tlsCertVerificationEnabled;
    }

    public GelfConfiguration enableTlsCertVerification() {
        this.tlsCertVerificationEnabled = true;
        return this;
    }

    public GelfConfiguration disableTlsCertVerification() {
        this.tlsCertVerificationEnabled = false;
        return this;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }

    public GelfConfiguration reconnectDelay(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public GelfConfiguration connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public GelfConfiguration tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public GelfConfiguration sendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    private String checkHostname(String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        if (hostname.trim().isEmpty()) {
            throw new IllegalArgumentException("hostname can't be empty");
        }
        return hostname;
    }

    private int checkPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port out of range: " + port);
        }
        return port;
    }
}

