/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient;

import java.util.HashMap;
import java.util.Map;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfMessageVersion;

public class GelfMessageBuilder {
    private final GelfMessageVersion version;
    private final String host;
    private String message;
    private String fullMessage;
    private Double timestamp;
    private GelfMessageLevel level = GelfMessageLevel.ALERT;
    private final Map<String, Object> fields = new HashMap<String, Object>();

    public GelfMessageBuilder(String message) {
        this(message, "localhost");
    }

    public GelfMessageBuilder(String message, String host) {
        this(message, host, GelfMessageVersion.V1_1);
    }

    public GelfMessageBuilder(String message, String host, GelfMessageVersion version) {
        this.message = message;
        this.host = host;
        this.version = version;
    }

    public GelfMessageBuilder message(String message) {
        this.message = message;
        return this;
    }

    public GelfMessageBuilder fullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
        return this;
    }

    public GelfMessageBuilder timestamp(double timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public GelfMessageBuilder level(GelfMessageLevel level) {
        this.level = level;
        return this;
    }

    public GelfMessageBuilder additionalField(String key, Object value) {
        this.fields.put(key, value);
        return this;
    }

    public GelfMessageBuilder additionalFields(Map<String, Object> additionalFields) {
        this.fields.putAll(additionalFields);
        return this;
    }

    public GelfMessage build() {
        if (this.message == null) {
            throw new IllegalArgumentException("message must not be null!");
        }
        if (this.host == null || this.host.trim().isEmpty()) {
            throw new IllegalArgumentException("host must not be null or empty!");
        }
        if (this.version == null) {
            throw new IllegalArgumentException("version must not be null!");
        }
        GelfMessage gelfMessage = new GelfMessage(this.message, this.host, this.version);
        gelfMessage.setLevel(this.level);
        if (this.fullMessage != null) {
            gelfMessage.setFullMessage(this.fullMessage);
        }
        if (this.timestamp != null) {
            gelfMessage.setTimestamp(this.timestamp);
        }
        gelfMessage.addAdditionalFields(this.fields);
        return gelfMessage;
    }
}

