/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.SocketAddress;
import javax.net.ssl.TrustManagerFactory;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.encoder.GelfMessageJsonEncoder;
import org.graylog2.gelfclient.encoder.GelfTcpFrameDelimiterEncoder;
import org.graylog2.gelfclient.transport.AbstractGelfTransport;
import org.graylog2.gelfclient.transport.GelfSenderThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfTcpTransport
extends AbstractGelfTransport {
    private static final Logger LOG = LoggerFactory.getLogger(GelfTcpTransport.class);

    public GelfTcpTransport(GelfConfiguration config) {
        super(config);
    }

    @Override
    protected void createBootstrap(EventLoopGroup workerGroup) {
        Bootstrap bootstrap = new Bootstrap();
        final GelfSenderThread senderThread = new GelfSenderThread(this.queue, this.config.getMaxInflightSends());
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.getConnectTimeout())).option(ChannelOption.TCP_NODELAY, (Object)this.config.isTcpNoDelay())).option(ChannelOption.SO_KEEPALIVE, (Object)this.config.isTcpKeepAlive())).remoteAddress((SocketAddress)this.config.getRemoteAddress()).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (GelfTcpTransport.this.config.isTlsEnabled()) {
                    SslContext sslContext;
                    LOG.debug("TLS enabled.");
                    if (!GelfTcpTransport.this.config.isTlsCertVerificationEnabled()) {
                        LOG.debug("TLS certificate verification disabled!");
                        sslContext = SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE);
                    } else if (GelfTcpTransport.this.config.getTlsTrustCertChainFile() != null) {
                        LOG.debug("TLS certificate chain file: {}", (Object)GelfTcpTransport.this.config.getTlsTrustCertChainFile());
                        sslContext = SslContext.newClientContext((File)GelfTcpTransport.this.config.getTlsTrustCertChainFile());
                    } else {
                        sslContext = SslContext.newClientContext();
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new GelfTcpFrameDelimiterEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new GelfMessageJsonEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        senderThread.start(ctx.channel());
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        LOG.info("Channel disconnected!");
                        senderThread.stop();
                        GelfTcpTransport.this.scheduleReconnect((EventLoopGroup)ctx.channel().eventLoop());
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        LOG.error("Exception caught", cause);
                    }
                }});
            }
        });
        if (this.config.getSendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.config.getSendBufferSize());
        }
        bootstrap.connect().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    LOG.debug("Connected!");
                } else {
                    LOG.error("Connection failed: {}", (Object)future.cause().getMessage());
                    GelfTcpTransport.this.scheduleReconnect((EventLoopGroup)future.channel().eventLoop());
                }
            }
        });
    }
}

