/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient.transport;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGelfTransport
implements GelfTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGelfTransport.class);
    protected final GelfConfiguration config;
    protected final BlockingQueue<GelfMessage> queue;
    private final EventLoopGroup workerGroup;

    public AbstractGelfTransport(GelfConfiguration config, BlockingQueue<GelfMessage> queue) {
        this.config = config;
        this.queue = queue;
        this.workerGroup = new NioEventLoopGroup(config.getThreads(), (ThreadFactory)new DefaultThreadFactory(this.getClass(), true));
        this.createBootstrap(this.workerGroup);
    }

    public AbstractGelfTransport(GelfConfiguration config) {
        this(config, new LinkedBlockingQueue<GelfMessage>(config.getQueueSize()));
    }

    protected abstract void createBootstrap(EventLoopGroup var1);

    protected void scheduleReconnect(final EventLoopGroup workerGroup) {
        workerGroup.schedule(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Starting reconnect!");
                AbstractGelfTransport.this.createBootstrap(workerGroup);
            }
        }, (long)this.config.getReconnectDelay(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void send(GelfMessage message) throws InterruptedException {
        LOG.debug("Sending message: {}", (Object)message);
        this.queue.put(message);
    }

    @Override
    public boolean trySend(GelfMessage message) {
        LOG.debug("Trying to send message: {}", (Object)message);
        return this.queue.offer(message);
    }

    @Override
    public void stop() {
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
    }
}

