/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.graylog2.GelfMessage;
import org.graylog2.GelfSender;
import org.graylog2.GelfSenderResult;

public class GelfUDPSender
implements GelfSender {
    private InetAddress host;
    private int port;
    private DatagramChannel channel;
    private static final int MAX_RETRIES = 5;

    public GelfUDPSender() {
    }

    public GelfUDPSender(String host) throws IOException {
        this(host, 12201);
    }

    public GelfUDPSender(String host, int port) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.channel = this.initiateChannel();
    }

    private DatagramChannel initiateChannel() throws IOException {
        DatagramChannel resultingChannel = DatagramChannel.open();
        resultingChannel.socket().bind(new InetSocketAddress(0));
        resultingChannel.connect(new InetSocketAddress(this.host, this.port));
        resultingChannel.configureBlocking(false);
        return resultingChannel;
    }

    public GelfSenderResult sendMessage(GelfMessage message) {
        if (!message.isValid()) {
            return GelfSenderResult.MESSAGE_NOT_VALID;
        }
        return this.sendDatagrams(message.toUDPBuffers());
    }

    private GelfSenderResult sendDatagrams(ByteBuffer[] bytesList) {
        int tries = 0;
        IOException lastException = null;
        while (true) {
            try {
                for (ByteBuffer buffer : bytesList) {
                    this.channel.write(buffer);
                }
                return GelfSenderResult.OK;
            }
            catch (IOException e) {
                lastException = e;
                if (++tries <= 5) continue;
                return new GelfSenderResult(-1, lastException);
            }
            break;
        }
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

