/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.graylog2.GelfMessage;
import org.graylog2.GelfSender;

public class GelfTCPSender
implements GelfSender {
    private boolean shutdown = false;
    private InetAddress host;
    private int port;
    private Socket socket;

    public GelfTCPSender() {
    }

    public GelfTCPSender(String host, int port) throws IOException {
        this.host = InetAddress.getByName(host);
        this.port = port;
        this.socket = new Socket(host, port);
    }

    @Override
    public boolean sendMessage(GelfMessage message) {
        if (this.shutdown || !message.isValid()) {
            return false;
        }
        try {
            if (this.socket == null) {
                this.socket = new Socket(this.host, this.port);
            }
            this.socket.getOutputStream().write(message.toTCPBuffer().array());
            return true;
        }
        catch (IOException e) {
            this.socket = null;
            return false;
        }
    }

    @Override
    public void close() {
        this.shutdown = true;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

