/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.graylog2.GelfAMQPSender;
import org.graylog2.GelfMessage;
import org.graylog2.GelfSender;
import org.graylog2.GelfTCPSender;
import org.graylog2.GelfUDPSender;

public class GelfHandler
extends Handler {
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private String graylogHost;
    private String amqpURI;
    private String amqpExchangeName;
    private String amqpRoutingKey;
    private int amqpMaxRetries;
    private String originHost;
    private int graylogPort;
    private String facility;
    private GelfSender gelfSender;
    private boolean extractStacktrace;
    private Map<String, String> fields;

    public GelfHandler() {
        String property;
        LogManager manager = LogManager.getLogManager();
        String prefix = this.getClass().getName();
        this.graylogHost = manager.getProperty(prefix + ".graylogHost");
        String port = manager.getProperty(prefix + ".graylogPort");
        this.graylogPort = null == port ? 12201 : Integer.parseInt(port);
        this.originHost = manager.getProperty(prefix + ".originHost");
        this.extractStacktrace = "true".equalsIgnoreCase(manager.getProperty(prefix + ".extractStacktrace"));
        int fieldNumber = 0;
        this.fields = new HashMap<String, String>();
        while (null != (property = manager.getProperty(prefix + ".additionalField." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                this.fields.put(property.substring(0, index), property.substring(index + 1));
            }
            ++fieldNumber;
        }
        this.facility = manager.getProperty(prefix + ".facility");
        this.amqpURI = manager.getProperty(prefix + ".amqpURI");
        this.amqpExchangeName = manager.getProperty(prefix + ".amqpExchangeName");
        this.amqpRoutingKey = manager.getProperty(prefix + ".amqpRoutingKey");
        String maxRetries = manager.getProperty(prefix + ".amqpMaxRetries");
        this.amqpMaxRetries = maxRetries == null ? 0 : Integer.valueOf(maxRetries);
        String level = manager.getProperty(prefix + ".level");
        if (null != level) {
            this.setLevel(Level.parse(level.trim()));
        } else {
            this.setLevel(Level.INFO);
        }
        String filter = manager.getProperty(prefix + ".filter");
        try {
            if (null != filter) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clazz.newInstance());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String testSender = manager.getProperty(prefix + ".graylogTestSenderClass");
        try {
            if (null != testSender) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(testSender);
                this.gelfSender = (GelfSender)clazz.newInstance();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public synchronized void flush() {
    }

    private String getOriginHost() {
        if (null == this.originHost) {
            this.originHost = this.getLocalHostName();
        }
        return this.originHost;
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.reportError("Unknown local hostname", uhe, 0);
            return null;
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (null == this.gelfSender) {
            if (this.graylogHost == null && this.amqpURI == null) {
                this.reportError("Graylog2 hostname and amqp uri are empty!", null, 1);
            } else if (this.graylogHost != null && this.amqpURI != null) {
                this.reportError("Graylog2 hostname and amqp uri are both informed!", null, 1);
            } else {
                try {
                    if (this.graylogHost.startsWith("tcp:")) {
                        String tcpGraylogHost = this.graylogHost.substring(4, this.graylogHost.length());
                        this.gelfSender = new GelfTCPSender(tcpGraylogHost, this.graylogPort);
                    } else if (this.graylogHost.startsWith("udp:")) {
                        String udpGraylogHost = this.graylogHost.substring(4, this.graylogHost.length());
                        this.gelfSender = new GelfUDPSender(udpGraylogHost, this.graylogPort);
                    } else {
                        this.gelfSender = this.amqpURI != null ? new GelfAMQPSender(this.amqpURI, this.amqpExchangeName, this.amqpRoutingKey, this.amqpMaxRetries) : new GelfUDPSender(this.graylogHost, this.graylogPort);
                    }
                }
                catch (UnknownHostException e) {
                    this.reportError("Unknown Graylog2 hostname:" + this.graylogHost, e, 1);
                }
                catch (SocketException e) {
                    this.reportError("Socket exception", e, 1);
                }
                catch (IOException e) {
                    this.reportError("IO exception", e, 1);
                }
                catch (URISyntaxException e) {
                    this.reportError("AMQP uri exception", e, 1);
                }
                catch (NoSuchAlgorithmException e) {
                    this.reportError("AMQP algorithm exception", e, 1);
                }
                catch (KeyManagementException e) {
                    this.reportError("AMQP key exception", e, 1);
                }
            }
        }
        if (null == this.gelfSender || !this.gelfSender.sendMessage(this.makeMessage(record))) {
            this.reportError("Could not send GELF message", null, 1);
        }
    }

    @Override
    public void close() {
        if (null != this.gelfSender) {
            this.gelfSender.close();
            this.gelfSender = null;
        }
    }

    private GelfMessage makeMessage(LogRecord record) {
        Throwable thrown;
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        if (message == null) {
            message = "";
        }
        if (parameters != null && parameters.length > 0 && (message = MessageFormat.format(message, parameters)).equals(record.getMessage())) {
            try {
                message = String.format(message, parameters);
            }
            catch (IllegalFormatConversionException e) {
                message = record.getMessage();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        String shortMessage = message.length() > 250 ? message.substring(0, 249) : message;
        if (this.extractStacktrace && null != (thrown = record.getThrown())) {
            StringWriter sw = new StringWriter();
            thrown.printStackTrace(new PrintWriter(sw));
            message = message + "\n\r" + sw.toString();
        }
        GelfMessage gelfMessage = new GelfMessage(shortMessage, message, record.getMillis(), String.valueOf(this.levelToSyslogLevel(record.getLevel())));
        gelfMessage.addField("SourceClassName", record.getSourceClassName());
        gelfMessage.addField("SourceMethodName", record.getSourceMethodName());
        if (null != this.getOriginHost()) {
            gelfMessage.setHost(this.getOriginHost());
        }
        if (null != this.facility) {
            gelfMessage.setFacility(this.facility);
        }
        if (null != this.fields) {
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                gelfMessage.addField(entry.getKey(), entry.getValue());
            }
        }
        return gelfMessage;
    }

    private int levelToSyslogLevel(Level level) {
        int syslogLevel = level.intValue() == Level.SEVERE.intValue() ? 3 : (level.intValue() == Level.WARNING.intValue() ? 4 : (level.intValue() == Level.INFO.intValue() ? 6 : 7));
        return syslogLevel;
    }

    public void setExtractStacktrace(boolean extractStacktrace) {
        this.extractStacktrace = extractStacktrace;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public void setAdditionalField(String entry) {
        if (entry == null) {
            return;
        }
        int index = entry.indexOf(61);
        if (-1 != index) {
            String key = entry.substring(0, index);
            String val = entry.substring(index + 1);
            if (key.equals("")) {
                return;
            }
            this.fields.put(key, val);
        }
    }

    public Map<String, String> getFields() {
        return this.fields;
    }
}

